# Redispersió en una taula de dispersió amb sinònims encadenats indirectes i nova mida nombre primer

Es disposa d'un diccionari que emmagatzema únicament claus de tipus
`string`, implementat mitjançant una taula de dispersió amb
encadenaments indirectes (els sinònims estan en llistes simplement
encadenades ordenades per clau).

Entre els fitxers que s'adjunten en aquest exercici, trobaràs:

- `dicc.hpp`: especificació pública de la classe `dicc`.

- `dicc.old.rep`: representació interna (estructura de dades i atributs
  privats).

- `dicc.cpp`: implementació de la classe (mètodes ja resolts).

La teva feina és:

- Canviar el nom del fitxer de representació:

      mv dicc.old.rep dicc.rep

  Així podràs modificar la representació de la classe i afegir mètodes
  privats.

- Crear el fitxer `solution.cpp`: fitxer on has d'implementar **la teva
  solució**.

Has d'implementar el mètode següent de la classe `dicc`:

    /* Mètode modificador.
       Realitza la redispersió de la taula de dispersió.
       La mida de la nova taula serà el primer nombre primer
       major o igual que 2*_M + 1, on _M és la mida actual de la taula.
       Tots els elements del diccionari es reubiquen a la nova taula
       utilitzant la funció de dispersió corresponent. */
    void redispersio();

Aquest mètode ha de realitzar la **redispersió** de la taula de
dispersió:

1.  La nova mida de la taula ha de ser el **primer nombre primer** major
    o igual que $$2 \cdot M + 1,$$ on $M$ és la mida actual de la taula.

2.  S'han de **recol·locar tots els elements** del diccionari a la nova
    taula, recalculant el seu índex amb la funció de dispersió i la nova
    mida.

## [Observacions]{style="color: blue"}

- No es pot perdre cap element del diccionari durant la redispersió.

- El nombre d'elements del diccionari (consultable amb `quants()` o
  mitjançant l'atribut corresponent) **no ha de variar**.

- No s'han de crear claus noves ni duplicar-les.

- Es poden definir funcions i mètodes auxiliars si es considera
  necessari.

- Per calcular el valor de dispersió utilitza el mètode `h` que ja està
  implementat i que permet calcular un valor de dispersió entre 0 i
  `LONG_MAX` (el valor long int més gran que permet el compilador) a
  partir d'una clau.

- [**IMPORTANT**]{style="color: red"}: En la representació només pots
  afegir mètodes auxiliars o atributs, no pots modificar cap altra cosa.

- Recorda que has d'afegir a tots els mètodes que creïs les
  corresponents **Precondició** (Pre) i **Postcondició** (Post) i també
  el cost.

- També pots trobar entre els fitxers que s'adjunten amb l'exercici el
  fitxer `main.cpp` (programa principal) que crea la taula de dispersió
  i afegeix elements. .

- Per a pujar la teva solució, has de crear el fitxer `solution.tar`
  així:

      tar cf solution.tar solution.cpp dicc.rep

## Entrada

L'entrada té tres línies: la primera conté un natural positiu amb la
dimensió inicial de la taula de dispersió i les altres dos contenen
elements separats amb espais, són els elements que s'insereixen en el
diccionari.

## Sortida

Escriu el contingut del diccionari dos vegades: després d'inserir el
primer conjunt d'elements i després d'inserir el segon conjunt
d'elements. Cada vegada es mostra en diferents línies la quantitat
d'elements que té i els elements que conté cadascuna de les llistes de
sinònims encadenats indirectes (els elements de cada llista apareixen
separats amb un espai i en el mateix ordre en que es guarden).

Per més detalls de com és l'entrada i la sortida consulta els jocs de
proves públics.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T20:33:32.803Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
