#include <cassert>
#include <iostream>
#include <vector>

using namespace std;

typedef vector <int>   Vector;
typedef vector<Vector> Matriu;

/*
 * PRE:  M.size() > 0 and M[0].size() > 0, és una matriu d'enters.
 *		 M[0][0] >= 0.
 *		 potencia > 0, objectiu > 0.
 *		 recorregut.size() > 0 i recorregut només conté 'N','S','E','O'.
 *
 * POST: Retorna ACONSEGUIT si el recorregut és capaç de recollir
 * 		 almenys tants premis com objectiu.
 *		 Retorna ESGOTAT si recull tantes pedres o més que potència.
 * 		 Retorna NO HI ARRIBEM si el recorregut no aconsegueix recollir
 * 		 		 tants premis com objectiu. 
 */

string matriu_laberint(const Matriu& M,int k, int objectiu, const string& recorregut);

void escriu_matriu(const Matriu& M)
{
	assert(M.size() > 0);
	int f = M.size();
	int c = M[0].size();
	
	for (int i = 0 ; i < f ; i++)
	{
		for (int j = 0 ; j < c ; j++)
			cout << M[i][j] << " ";
		cout << endl;
	}
	return;
}

void llegeix_matriu(Matriu& M, int f, int c)
{
	assert(M.size() > 0);
	assert(M.size() == f and M[0].size() == c);
	
	for (int i = 0 ; i < f ; i++)
		for (int j = 0 ; j < c ; j++)
			cin >> M[i][j];

	return;
}

int main() 
{
	int f,c;
	cin >> f >> c;
	
	Matriu M(f,Vector(c,0));

	llegeix_matriu(M,f,c);
//	escriu_matriu(M);

	int k,objectiu;
	string recorregut;
	while (cin >> k >> objectiu >> recorregut)
	{
		string s = matriu_laberint(M,k,objectiu,recorregut);
		cout << "POTENCIA: " << k << " OBJECTIU: " << objectiu;
		cout << " RECORREGUT: " << recorregut << " RESULTAT: " << s << endl;
	}

	return 0;
}
