# Haskell --- Infinite lists

The goal of this problem is to work the definition of infinite lists. In
particular, you are required to define functions that generate infinite
lists to:

1.  Generate the sequence of ones $[1,1,1,1,1,1,1,1,\dots]$.

2.  Generate the sequence of the natural numbers
    $[0,1,2,3,4,5,6,7\dots]$.

3.  Generate the sequence of the integer numbers
    $[0,1,-1,2,-2,3,-3,4\dots]$.

4.  Generate the sequence of the triangular numbers:
    $0,1,3,6,10,15,21,28,\dots]$.

5.  Generate the sequence of the factorial numbers:
    $[1,1,2,6,24,120,720,5040,\dots]$.

6.  Generate the sequence of the Fibonacci numbers:
    $[0,1,1,2,3,5,8,13,\dots]$.

7.  Generate the sequence of prime numbers:
    $[2,3,5,7,11,13,17,19,\dots]$.

8.  Generate the ordered sequence of the Hamming numbers:
    $[1,2,3,4,5,6,8,9,\dots]$. The Hamming numbers are those that only
    have 2, 3 and 5 as prime divisors.

9.  Generate the *look-and-say* sequence:
    $[1,11,21,1211,111221,312211,13112221,1113213211,\dots]$.

10. Generate the sequences of rows of the Tartaglia triangle (also known
    as Pascal's triangle): $[[1],[1,1],[1,2,1],[1,3,3,1],\dots]$.

## Specification

Define the following functions:

        ones :: [Integer]
        nats :: [Integer]
        ints :: [Integer]
        triangulars :: [Integer]
        factorials :: [Integer]
        fibs :: [Integer]
        primes :: [Integer]
        hammings :: [Integer]
        lookNsay :: [Integer]
        tartaglia :: [[Integer]]

## Observation

In this problem you cannot use infinite enumerations such as $[1..]$,
but you are advised to use higer-order functions such as *map*, *scanl*,
*iterate*, *filter*, \...

## Scoring

Each function score 10 points.

## Problem information

Author: Unknown\
Translator: Jordi Petit

Generation: 2026-02-03T17:04:41.803Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
