# Twin Primes

Twin prime numbers are pairs of prime numbers that differ by 2. That is,
$p$ and $q$ (with $p < q$) are twin primes if $p$ and $q$ are primes and
$q = p + 2$. Except for the case of 2 and 3, this is the smallest
difference that can exist between two primes. The first examples of the
list of twin primes are the pairs $(3, 5)$, $(5,7)$ and $(11,13)$.

The term was first used by the German mathematician Paul Stäckel who, at
the end of the 19th century, made some numerical calculations related to
these numbers and other related questions. It is not known if there are
infinite twin prime numbers. The twin prime conjecture that states that,
in fact, there are infinite twin primes, has not yet been
proven\[Wikipedia\].

Write a program that, given a natural number $n>0$, calculates the
$n$-th pair of twin primes. For example, if $n = 3$, the program must
calculate the twin primes 11 and 13.

Your program should define and use the \@nth_twin_primes(n: int) -\>
tuple\[int, int\]@ function, which returns the $n$-pair of twin numbers
for an $n \ge 1$. Your program should also define and use the
\@are_primes(m: int, n: int) -\> bool@ function, which tells if $m$ and
$n$ are primer numbers, for $m,n\ge 2$.

## Input

The input consist of a series of strictly positive integers $n$.

## Output

For each $n$ you must write a line with the two twin primes that form
the pair, separated by a space. Each pair must be in increasing order.

## Observation

As many pairs of numbers will be composite, it is not a good idea to
determine if both are prime separately in the \@are_primes@ function.

## Problem information

Author: Unknown\
Translator: Jordi Puig

Generation: 2026-01-25T12:19:19.093Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
