# El DNI (de nuevo)

Ahora que ya sabemos calcular la letra del DNI, pasamos a analizar la
parte de atrás del DNI. En ella aparecen una serie de dígitos y letras
como el siguiente ejemplo:

    IDESP12345678Z3<<<<<<<<<<<<<<< \\
    7410150M0903226ESP<<<<<<<<<<<4 \\
    DE<TAL<Y<CUAL<<FULANITO<<<<<<< \\

Existe una leyenda urbana que dice que el último dígito de la segunda
línea se corresponde con el número de personas que tienen el mismo
nombre y apellidos que el portador del DNI. Sin embargo, tal y como se
explica en la web `http://jpf.sdf1.org/dni/`, esto no es cierto.

Esta zona del DNI está compuesta por caracteres OCR, que están
preparados para ser leídos por máquinas. Ese dígito en concreto es sólo
un dígito de control para verificar que se ha leído correctamente.
Podemos definir los siguientes campos en esta zona de datos:

    1.[ID] 2.[ESP] 3.[12345678Z] 4.[3] 5.[<<<<<<<<<<<<<<<] \\
    6.[741015] 7.[0] 8.[M] 9.[090322] 10.[6] 11.[ESP] 12.[<<<<<<<<<<<] 13.[4] \\
    14.[DE<TAL<Y<CUAL<<FULANITO<<<<<<<]

1\. Tipo de documento \[ID\]\
2. Nación \[ESP\]\
3. Número de DNI \[12345678Z\]\
4. Dígito de control del campo 3\
5. Relleno\
6. Fecha de nacimiento (AAMMDD) \[741015\]\
7. Dígito de control del campo 6\
8. Sexo (M/F)\
9. Fecha de caducidad \[090322\]\
10. Dígito de control del campo 9\
11. Nacionalidad \[ESP\]\
12. Relleno\
13. Dígito de control de los campos 3, 4, 6, 7, 9 y 10 concatenados\
14. Nombre\

Para obtener el dígito de control de un campo, se tiene que separar el
campo por carácteres. Si tenemos una letra, debemos convertirla a un
número de acuerdo con la siguiente tabla:

::: NoShortVerb
   Resto   `0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25`
  ------- -----------------------------------------------------------------------
   Letra   `A B C D E F G H I J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z`

  : Conversión de carácter a dígito.
:::

Una vez todos los carácteres han sido convertidos a dígitos, tenemos una
secuencia de números. A continuación, sumamos todos los dígitos
aplicando un peso 7-3-1. Esto significa que el primer dígito se
multiplica por 7, el segundo por 3, el tercero por 1, el cuarto por 7,
etc. La última cifra del resultado obtenido es el dígito de control.
Podemos ver este proceso en el siguiente ejemplo. Tenemos el campo
$12345678Z$. Separamos en carácteres (1 2 3 4 5 6 7 8 Z) y convertimos
la letra Z en un número (se corresponde con el 25). A continuación
hacemos la suma de los números con peso 7-3-1:
$$1\cdot7+2\cdot3+3\cdot1+4\cdot7+5\cdot3+6\cdot1+7\cdot7+8\cdot3+9\cdot1+25\cdot7=163$$
De manera que el número de control sería el **3**.

El objetivo de este problema es escribir un programa que, dados los
datos de un DNI, calcule el dígito de control que se corresponde con el
campo número 13. Cuidado: concatenar 2 campos significa poner el segundo
campo a continuación del primero.

## Entrada

La entrada consiste en una secuencia de los campos de datos de
diferentes DNIs necesarios para calcular los dígitos de control (3, 6 y
9). Los campos se dan en una linea, separados por un espacio y ordenados
de acuerdo con el formato previamente explicado. El campo 3 es un número
de 8 cifras junto con un carácter (NIF). El campo 6 es un número de 6
cifras y el campo 9 un número de 6 cifras. Los carácteres siempre
estaran escritos en mayúsculas entre 'A' y 'Z' (no hay minúsculas ni
acentos).

## Salida

Para cada número dado, escribir una línea con el dígito de control que
se corresponde al campo número 13.

## Información del problema

Autoría: Miquel Moretó

Generación: 2026-01-25T12:17:52.585Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
