# DNI (again)

Now that we know to calculate the letter of the DNI, we are going to
analyze the back side of the DNI. There, a series of numbers and letters
appear, as in the following instance:

    IDESP12345678Z3<<<<<<<<<<<<<<< \\
    7410150M0903226ESP<<<<<<<<<<<4 \\
    DOE<<JOHN<<<<<<<<<<<<<<<<<<<<< \\

It exists an urban legend that says that the last number of the second
line corresponds to the number of people that has the same name and
surname that the owner of the DNI. However, as it is explained in the
web `http://jpf.sdf1.org/dni/`, it is not true.

This area of the DNI is composed by OCR characters, that are prepared to
be read by machines. In particular, that number only is a control number
to verify that it has been correctly read. We can define the following
fields in this data area:

    1.[ID] 2.[ESP] 3.[12345678Z] 4.[3] 5.[<<<<<<<<<<<<<<<] \\
    6.[741015] 7.[0] 8.[M] 9.[090322] 10.[6] 11.[ESP] 12.[<<<<<<<<<<<] 13.[4] \\
    14.[DOE<<JOHN<<<<<<<<<<<<<<<<<<<<<]

1\. Type document \[ID\]\
2. Nation \[ESP\]\
3. Number of DNI \[12345678Z\]\
4. Control number of field 3\
5. Filler\
6. Date of birth (AAMMDD) \[741015\]\
7. Control number of field 6\
8. Sex (M/F)\
9. Date of expiration\[090322\]\
10. Control number of field 9\
11. Nacionality \[ESP\]\
12. Filler\
13. Control number of field 3, 4, 6, 7, 9 and 10 concatenated\
14. Name\

To obtain the control number of a field, the field has to be separated
by characters. If we have a letter, we must change it into a number
according to the following table:

::: NoShortVerb
   Remainder   `0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25`
  ----------- -----------------------------------------------------------------------
    Letter     `A B C D E F G H I J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z`

  : Character to number conversion.
:::

Once that all the characters have been change into numbers, we have a
sequence of numbers. Then, we add all the numbers up applying a weight
7-3-1. It means that the first digit is multiplied by 7, the second one
by 3, the third one by 1, the fourth one by 7, etc. The last number of
the obtained result is the control digit. We can see this procress in
the following instance. We have the field $12345678Z$. We separe the
characters (1 2 3 4 5 6 7 8 Z) and we change letter Z into a number (it
corresponds to 25). Then, we do the sum of the numbers with weight
7-3-1:
$$1\cdot7+2\cdot3+3\cdot1+4\cdot7+5\cdot3+6\cdot1+7\cdot7+8\cdot3+9\cdot1+25\cdot7=163$$
So that the control number would be **3**.

The target of this problem is to write a program that, given the data of
a DNI, computes the control number that correspond to the field number
14. Warning: concatenating 2 fields means to put the second one after
the first one.

## Input

The input consists of a sequence of the data fields of different DNIs
necessary to compute the control numbers (3, 6 and 9). The fields are
given in a line, separated by a space and in the order previously
explained. The field 3 is a eight-figure number with a character (NIF).
The field 6 is a six-figure number and the field 9 is a six-figure
number. The characters will always be uppercase letters between 'A' and
'Z' (there is not lowercase letters nor accents).

## Output

For each given number, your program must print a line with the control
number that corresponds to the field number 13.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T12:17:57.123Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
