# Zeroes of polynomials

Given a function $f$ continuous in an interval $[a,b]$, and such that
$f(a) \cdot f(b) < 0$, a basic theorem of Mathematics states that there
must exist at least one zero of $f$ in $(a,b)$, that is, a real number
$z$ such that $a < z < b$ and $f(z) = 0$.

Given a polynomial $p(x) = c_4 x^4 + c_3 x^3 + c_2 x^2 + c_1 x + c_0$
with exactly one zero in $(0,1)$, can you find this zero?

## Input

Each input line describes a polynomial $p(x)$ of degree at most 4 with
exactly one zero in $(0,1)$. Each polynomial is given in decreasing
order of $i$ as follows: $c_4\ 4\ c_3\ 3\ c_2\ 2\ c_1\ 1\ c_0\ 0$. Every
$c_i$ is a real number. The pairs $c_i\ i$ with $c_i = 0$ are not
present in the input.

## Output

For every polynomial, print its case number, followed by an
approximation of its zero $z$ in $(0,1)$, with the following convention:
$z$ must be a real number with exactly 5 digits after the decimal point,
such that $0 \le z \leq 0.99999$ and $p(z) \cdot p(z + 0.00001) < 0$.
Always print the 5 decimal digits of $z$.

## Observations

- Every given polynomial is such that $p(x) \ne 0$ for every real number
  $x \in [0,1]$ that has 5 (or less) decimal digits after the decimal
  point.

- The test cases have no precisions issues. However, be aware that it is
  not wise to check the property $p(z) \cdot p(z + 0.00001) < 0$ just
  like this.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T12:15:23.123Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
