# Haskell --- FizzBuzz

In the famous article *Using FizzBuzz to Find Developers who Grok
Coding* (which you can find at
[http://imranontech.com/2007/01/24/using-fizzbuzz-to-find-developers-who-grok-coding/]{.sans-serif}),
Imran Ghory explains that most programmers interviewed for a job cannot
even write a simple program:

> On occasion you meet a developer who seems like a solid programmer.
> They know their theory, they know their language. They can have a
> reasonable conversation about programming. But once it comes down to
> actually producing code they just don't seem to be able to do it well.
>
> After a fair bit of trial and error I've discovered that people who
> struggle to code don't just struggle on big problems, or even smallish
> problems (i.e. write a implementation of a linked list). They struggle
> with tiny problems. So I set out to develop questions that can
> identify this kind of developer and came up with a class of questions
> I call "FizzBuzz Questions" named after a game children often play (or
> are made to play) in schools in the UK. An example of a Fizz-Buzz
> question is the following:
>
> > *Write a program that prints the numbers from 0 to 100, but: For
> > multiples of three print 'Fizz' instead of the number, and for the
> > multiples of five print 'Buzz'. For numbers which are multiples of
> > both three and five print 'FizzBuzz'.*
>
> Most good programmers should be able to write out on paper a program
> which does this in a under a couple of minutes. Want to know something
> scary? The majority of comp sci graduates can't. I've also seen self-
> proclaimed senior programmers take more than 10-15 minutes to write a
> solution.

Prove that you really can write such a program in Haskell, and with
style! (But don't be too slow\...)

## Specification

Define the function

        fizzBuzz :: [Either Int String]

that returns the infinite list of "FizzBuzz" for each integer starting
from zero.

## Problem information

Author: Unknown\
Translator: Jordi Petit

Generation: 2026-02-03T17:03:00.825Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
