# Seqüències malabaristes

Donat un real $x$, sigui $\lfloor x \rfloor$ com és habitual el màxim
enter $n$ tal que $n \le x$.

Una seqüència malabarista és una seqüència de naturals que comença amb
un $a_0 \ge 1$, i on cada terme posterior es defineix amb la recurrència
següent: $$a_{k+1} =
    {\begin{cases}
        \left\lfloor a_{k}^{\frac {1}{2}}\right\rfloor , & {\text{si }}a_{k}{\text{ és parell}}\\\\
        \left\lfloor a_{k}^{\frac {3}{2}}\right\rfloor , & {\text{si }}a_{k}{\text{ és senar}}.
    \end{cases}}$$

Com que el terme següent d'1 seria 1, si arribem a 1 acabem la
seqüència. Per exemple, $\{3, 5, 11, 36, 6, 2, 1\}$ i
$\{9, 27, 140, 11, 36, 6, 2, 1\}$ són seqüències malabaristes. Es creu
que totes les seqüències malabaristes arriben a 1. Aquesta conjectura
s'ha verificat per a $a_0 \le 10^6$.

Donada una seqüència $S$, els pics són els $a_i \in S$ tals que
$a_{i-1} < a_i > a_{i+1}$. Anàlogament, els clots són els $a_i\in S$
tals que $a_{i-1} > a_i < a_{i+1}$.

## Entrada

L'entrada consisteix en diversos $a_0$ entre 1 i $10^6$. Un 0 marca el
final de l'entrada.

## Sortida

Per a cada $a_0$ donada, escriviu la longitud de la seqüència
malabarista que comença en $a_0$, el nombre de pics, i el nombre de
clots. Amb les $a_0$ donades, cap element de cap seqüència serà més gran
que $10^9$.

## Observacions

- Recordeu que la funció \@sqrt()@ es troba a @\<cmath\>@.

- Valorarem positivament que implementeu i feu servir un procediment

          void malabarista(int a0, int& passos, int& pics, int& clots);

  que donat \@a0@ deixi el resultat demanat als tres paràmetres de
  sortida.

## Informació del problema

Autoria: Maria Blesa

Generació: 2026-01-25T12:09:53.518Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
