# Expressions regulars

Aquí tractem amb expressions regulars simplificades, les quals
codifiquen paraules. En el que segueix, sigui $P$ una paraula no buida
formada només amb lletres minúscules, sigui $D$ un dígit entre 1 i 9, i
sigui $S = E_1, \dots, E_n$ una seqüència no buida d'expressions
regulars. Una expressió regular pot ser:

- $D$`[`$P$`]` : codifica $D$ còpies de $P$.

- $D$`[`$S$`]` : codifica $D$ còpies de la concatenació de les
  codificacions de $E_1$, ..., $E_n$.

Diversos exemples:

- `1[hola]` codifica `hola`.

- `3[hi]` codifica `hihihi`.

- `1[1[hola]3[hi]]` codifica `holahihihi`.

- `2[1[hola]3[hi]]` codifica `holahihihiholahihihi`.

Com podeu veure als exemples d'entrada, aquesta definició recursiva
permet que hi hagi tants nivells com es vulgui de `[` \... `]`.

## Entrada

L'entrada consisteix en diverses expressions regulars.

## Sortida

Escriviu la paraula codificada per cada expressió regular donada.

## Observació

Si $s$ i $t$ són strings, i $c$ és un caràcter, aquestes operacions són
vàlides:

        s += t; // afegeix una copia de t a la dreta d's
        s += c; // afegeix una copia de c a la dreta d's

## Pista

La solució esperada és recursiva. El `main()` només conté:

        char c;
        while (cin >> c) cout << expressio(c) << endl;

## Informació del problema

Autoria: Maria Blesa

Generació: 2026-01-25T12:05:56.654Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
