# Ranges

Els ranges de Python són seqüències de nombres enters. N'hi ha tres
versions:

- $\text{range}(n)$: Si $n > 0$, és $[0, \ldots, n - 1]$; altrament, és
  una seqüència buida.

- $\text{range}(a, b)$: Si $b > a$, és $[a, \ldots, b - 1]$; altrament,
  és una seqüència buida.

- $\text{range}(a, b, d)$: És $[a, a + d, a + 2d, \ldots, a + jd]$, on
  $j \ge 0$ és el valor màxim que fa que $a + jd < b$, si $d > 0$, o que
  fa que $a + jd > b$, si $d < 0$. Si tal valor no existeix, és una
  seqüència buida.

Com exemples, $\text{range}(3) = [0, 1, 2]$,
$\text{range}(-2, 2) = [-2, -1, 0, 1]$,
$\text{range}(7, 15, 4) = [7, 11]$,
$\text{range}(-7, -15, -4) = [-7, -11]$,
$\text{range}(-15, -7, -4) = []$, $\text{range}(8, 8, 4) = []$.

Donat un enter $x$ i un range de Python, digueu si $x$ pertany al range.

## Entrada

L'entrada consisteix en diversos casos, cadascun en una línia. Cada cas
comença amb dos enters $x$ i $k$, amb $1 \le k \le 3$, seguits de $k$
enters $y_1, \ldots, y_k$. Tots els valors $x, y_1, \ldots, y_k$ estan
entre $-10^8$ i $10^8$. Cap $y_3$ és igual a 0.

## Sortida

Per a cada cas, digueu si $x$ pertany a
$\text{range}(y_1, \ldots, y_k)$.

## Pista

Recordeu que en C++ l'operador `%` té un comportament "estrany" amb
nombres negatius.

## Informació del problema

Autoria: Víctor Martín

Generació: 2026-01-25T12:03:42.420Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
