#  Coeficientes binomiales

El coeficiente binomial o número combinatorio $\binom{n}{k}$ es el
número de maneras de escoger $k$ objectos de un total de $n$. Su fórmula
es bien conocida: $$\binom{n}{k} = \frac{ n! }{ k! (n-k)! } \enspace ,$$
donde $n!=n\cdot (n-1)\cdots 2\cdot 1$. Esta fórmula no es demasiado
práctica desde un punto de vista computacional, porque se tiene que
trabajar con números muy grandes (los factoriales) para acabar
obteniendo un resultado mucho más pequeño. Por ejemplo,
$$\binom{20}{10} = \frac{ 20! }{10! 10!} = \frac{2432902008176640000}{1316819440000} = 184756 \enspace ,$$
donde se puede ver que, pese a que el número final sólo tiene 6 cifras,
nos ha hecho falta calcular $20!$, que tiene 19. Esto puede ser un
problema, puesto que el tipo `int` de 32 bits no puede almacenar números
de más de 10 cifras.

Este, sin embargo, no es el único modo de calcular $\binom{n}{k}$. Por
ejemplo, los números combinatorios satisfacen la propiedad siguiente:
$$\binom{n}{k} = \left\{
\begin{array}{ll}
1 & \mbox{si $k = 0$ o $k = n$} \\
\binom{n-1}{k-1} + \binom{n-1}{k} & \mbox{si $0<k<n$}
\end{array}
\right.$$ Esta fórmula recursiva permite calcular los números
combinatorios sin multiplicaciones ni divisiones, mediante un
procedimiento conocido hoy en día como "Triángulo de Pascal" o
"Triángulo de Tartaglia", aunque tenga referencias históricas con más de
1000 años de antigüedad:

::::: center
::: NoShortVerb
  ----- ----- ----- ----- ----- ----- ----- ----- -----
                           $1$                    
                     $1$         $1$              
               $1$         $2$         $1$        
         $1$         $3$         $3$         $1$  
   $1$         $4$         $6$         $1$         $1$
                           ...                    
  ----- ----- ----- ----- ----- ----- ----- ----- -----
:::

$\qquad$

::: NoShortVerb
  ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ----------------
                                                                       $\binom{0}{0}$                                                     
                                                      $\binom{1}{0}$                    $\binom{1}{1}$                                    
                                     $\binom{2}{0}$                    $\binom{2}{1}$                    $\binom{2}{2}$                   
                    $\binom{3}{0}$                    $\binom{3}{1}$                    $\binom{3}{2}$                    $\binom{3}{3}$  
   $\binom{4}{0}$                    $\binom{4}{1}$                    $\binom{4}{2}$                    $\binom{4}{3}$                    $\binom{4}{4}$
                                                                            ...                                                           
  ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ----------------
:::
:::::

Para calcular más números combinatorios sólo hay que llenar más filas
del triángulo. Usad esta idea para calcular diversos números
combinatorios.

## Entrada

La entrada consiste en diversos casos, cada uno con dos naturales $n$ y
$k$, donde $0\le n\le 30$ y $0\le k\le n$.

## Salida

Para cada caso, escribid $\binom{n}{k}$.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T12:02:45.405Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
