# Coeficients binomials

El coeficient binomial o nombre combinatori $\binom{n}{k}$ és el nombre
de maneres de triar $k$ objectes d'un total de $n$. La seva fórmula és
ben coneguda: $$\binom{n}{k} = \frac{ n! }{ k! (n-k)! } \enspace ,$$ on
$n!=n\cdot (n-1)\cdots 2\cdot 1$. Aquesta fórmula no és massa pràctica
des d'un punt de vista computacional, perquè s'ha de treballar amb
nombres molt grossos (els factorials) per acabar obtenint un resultat
molt més petit. Per exemple,
$$\binom{20}{10} = \frac{ 20! }{10! 10!} = \frac{2432902008176640000}{1316819440000} = 184756 \enspace ,$$
on es pot veure que, tot i que el nombre final només té 6 xifres, ens ha
fet falta calcular $20!$, que en té 19. Això pot ser un problema, ja que
el tipus `int` de 32 bits no pot emmagatzemar nombres amb més de 10
xifres.

Aquesta, però, no és l'única manera de calcular $\binom{n}{k}$. Per
exemple, els nombres combinatoris satisfan la propietat següent:
$$\binom{n}{k} = \left\{
\begin{array}{ll}
1 & \mbox{si $k = 0$ o $k = n$} \\
\binom{n-1}{k-1} + \binom{n-1}{k} & \mbox{si $0<k<n$}
\end{array}
\right.$$ Aquesta fórmula recursiva permet calcular els nombres
combinatoris sense multiplicacions ni divisions, mitjançant un
procediment conegut avui en dia com a "Triangle de Pascal" o "Triangle
de Tartaglia", encara que tingui referències històriques amb més de 1000
anys d'antiguitat:

::::: center
::: NoShortVerb
  ----- ----- ----- ----- ----- ----- ----- ----- -----
                           $1$                    
                     $1$         $1$              
               $1$         $2$         $1$        
         $1$         $3$         $3$         $1$  
   $1$         $4$         $6$         $1$         $1$
                           ...                    
  ----- ----- ----- ----- ----- ----- ----- ----- -----
:::

$\qquad$

::: NoShortVerb
  ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ----------------
                                                                       $\binom{0}{0}$                                                     
                                                      $\binom{1}{0}$                    $\binom{1}{1}$                                    
                                     $\binom{2}{0}$                    $\binom{2}{1}$                    $\binom{2}{2}$                   
                    $\binom{3}{0}$                    $\binom{3}{1}$                    $\binom{3}{2}$                    $\binom{3}{3}$  
   $\binom{4}{0}$                    $\binom{4}{1}$                    $\binom{4}{2}$                    $\binom{4}{3}$                    $\binom{4}{4}$
                                                                            ...                                                           
  ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ---------------- ----------------
:::
:::::

Per calcular més nombres combinatoris només cal omplir més files del
triangle. Feu servir aquesta idea per calcular diversos nombres
combinatoris.

## Entrada

La entrada consisteix en diversos casos, cadascun amb dos naturals $n$ i
$k$, on $0\le n\le 30$ i $0\le k\le n$.

## Sortida

Per a cada cas, cal escriure $\binom{n}{k}$.

## Informació del problema

Autoria: Unknown\
Traducció: Carlos Molina

Generació: 2026-01-25T12:02:49.812Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
