# Haskell --- Parcial 2018-04-11

# Apartat 1: Llista infinita

Escriviu una funció `multEq :: Int -> Int -> [Int]` que, donats dos
nombres positius $x$ i $y$ diferents de zero, genera la llista infinita
ordenada creixentment que conté els nombres formats per la multiplicació
de la mateixa quantitat de $x$ que de $y$.

# Apartat 2: Selecció

Escriviu una funció `selectFirst :: [Int] -> [Int] -> [Int] -> [Int]`
que, donades tres llistes `l1`, `l2` i `l3` retona els elements de `l1`
que apareixen a `l2` en una posició menor estrictament que a `l3`. Si un
element apareix a `l2` i no a `l3` es considera que apareix en una
posició anterior.

# Apartat 3: *iterate* amb *scanl*

Definiu una funció `myIterate :: (a -> a) -> a -> [a]` que faci el
mateix que `iterate`, però implementada en termes d'`scanl`.

# Apartat 4: Taula de símbols

Considereu una taula de símbols genèrica que converteix textos
(`String`s) en valors de tipus `a` definida per
`type SymTab a = String -> Maybe a`.

La taula de símbols retorna un `Maybe a` i no un `a` perquè poder
indicar cerques sense èxit.

Les operacions sobre la taula de símbols són:

        empty :: SymTab a
        get :: SymTab a -> String -> Maybe a
        set :: SymTab a -> String -> a -> SymTab a

on `empty` crea una taula de símbols buida, `get` retorna el valor d'un
text a la taula de símbols (amb `Just` si hi és o `Nothing` si no hi
és), i `set` retorna una nova taula de símbols definint un nou valor per
a un símbol (i sobrescrivint el valor antic si el símbol ja era a la
taula).

Implementeu aquestes tres operacions sobre el `type` donat (que no podeu
canviar).

# Apartat 5: Expressions amb símbols

Considereu el següent tipus genèric per a expressions de tipus `a` amb
variables:

    data Expr a
        = Val a
        | Var String
        | Sum (Expr a) (Expr a)
        | Sub (Expr a) (Expr a)
        | Mul (Expr a) (Expr a)
        deriving Show

Escriviu una funció `eval :: (Num a) => SymTab a -> Expr a -> Maybe a`
que, evaluï una expressió utilitzant una taula de símbols, retornant
`Nothing` si alguna variables no està definida a la taula.

## Informació del problema

Autoria: Jordi Petit i Albert Rubio

Generació: 2026-02-03T17:06:21.715Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
