# Latin square

A latin square of order $n$ is a matrix $n \times n$ such that in each
row and column appears all the numbers between 1 and $n$. For instance,
$$\left(
\begin{array}{ccc}
2 & 3 & 1 \\
1 & 2 & 3 \\
3 & 1 & 2 \\
\end{array}
\right)
\qquad
\mbox{and}
\qquad
\left(
\begin{array}{cccc}
1 & 2 & 3 & 4 \\
2 & 1 & 4 & 3 \\
3 & 4 & 1 & 2 \\
4 & 3 & 2 & 1 \\
\end{array}
\right)$$ are respectively latin squares of order 3 and 4.

Using the declarations

        typedef vector<int> Row;
        typedef vector<Row> Square;

write a function

        bool is_latin(const Square& q);

that prints if \|q\| is a latin square or not.

## Precondition

\|q\| is not empty and really squared. All its numbers are natural.

## Observation

You only need to submit the required procedure; your main program will
be ignored.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T11:55:31.480Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
