# Quadrat llatí

Un quadrat llatí d'ordre $n$ és una matriu $n \times n$ tal que a cada
fila i a cada columna apareix cada un dels nombres entre 1 i $n$. Per
exemple, $$\left(
\begin{array}{ccc}
2 & 3 & 1 \\
1 & 2 & 3 \\
3 & 1 & 2 \\
\end{array}
\right)
\qquad
\mbox{i}
\qquad
\left(
\begin{array}{cccc}
1 & 2 & 3 & 4 \\
2 & 1 & 4 & 3 \\
3 & 4 & 1 & 2 \\
4 & 3 & 2 & 1 \\
\end{array}
\right)$$ són respectivament quadrats llatins d'ordres 3 i 4.

Utilitzant les declaracions

        typedef vector<int> Fila;
        typedef vector<Fila> Quadrat;

feu una funció

        bool es_llati(const Quadrat& q);

que digui si \|q\| és un quadrat llatí o no.

## Precondició

\|q\| és no buit i realment quadrat. Tots els seus nombres són naturals.

## Observació

Només cal enviar el procediment demanat; el programa principal serà
ignorat.

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T11:55:36.087Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
