# P0009. Solvent economies

s

Being $S=s_1, s_2, \ldots, s_n$ a sequence of integers. Its *derivative*
is the sequence
$$S'=(s_2-s_1), \enspace (s_3-s_2), \enspace \ldots \enspace,
\enspace (s_n-s_{n-1})$$ and its *second derivative*$S''$ is the
derivative of $S'$.

A sequence is called *strictly increasing* if all the elements of its
derivative are strictly greater than zero. A sequence is called
*strictly convex* if all the elements of its second derivative are
strictly greater than zero.

Stock indices (as the IBEX 35 or the NASDAQ) measure economies, and
their evolution along the time can be seen like a sequence of integers.
In this context, it is said that an economy is *solvent* if its sequence
is strictly increasing (the wealth grows) or strictly convex (perhaps it
does not grow but it tends to the growth).

For instance, $S=1,3,10,12$ reflects a solvent economy because is
strictly increasing, although it is not strictly convex ($S'=2,7,2$;
$S''=5,-5$). $S=3,-2,-4,-1,5$ reflects a solvent economy also, because
is strictly convex, although it is not strictly increasing
($S'=-5,-2,3,6$; $S''=3,5,3$).

Your task is to write a program that reads a sequence of, at least,
three integers, and prints if they reflect a solvent economy or not.

## Input

The input is a sequence of three or more integers.

## Output

Your program must print textttsolvent economy" or
"`not solvent economy`", depending on the result, in a line.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T11:55:01.693Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
