# Colores HTML

Como probablemente sabrás, uno de los modos más conocidos (si bien, no
el único) de describir un *color* es el modelo RGB (Red-Green-Blue), que
describe la intensidad de los colores primarios que forman el color.
Típicamente, la intensidad de cada color primerario se da con un byte de
información (0-255), donde 0 indica la mínima intensidad y 255 la
máxima. Por ejemplo, el color $(0,255,0)$ es verde, y los colores
$(255,255,0)$ (rojo y verde) y $(0,255,255)$ (verde y azul) dan lugar a
los colores amarillo y cyan.

![image](color.png){width="20%"}

En el lenguaje HTML, los colores (las tuplas de 3 valores de 0 al 255)
se describen en notación hexadecimal usando exactamente 7 caracteres, en
la forma $\#rrggbb$, donde $rr$ (respectivamente, $gg$ y $bb$) es la
codificación en *hexadecimal* del valor $0-255$ correspondiente a la
intensidad del rojo (respectivamente, verde y azul). Los números
*hexadecimales* son aquellos donde usamos base 16
($0,1,\ldots,9,\text{a},\text{b},\text{c},\text{d},\text{e},\text{f}$)
en vez de base 10. Los números del 0 al 255 se representan, en
hexadecimal, del siguiente modo:
$$00, 01, 02, 03, \ldots, 09, 0\text{a}, 0\text{b}, 0\text{c}, 0\text{d}, 0\text{e}, 0\text{f}, 10, 11, \ldots, 1\text{e}, 1\text{f}, 20, 21, \ldots, \text{fc}, \text{fd}, \text{fe}, \text{ff}.$$

¿Te atreves a hacer un programa que sea capaz de convertir los colores
de uno a otro formato?

## Entrada

Una secuencia de casos de prueba, cada uno de los cuales ocupa una
línea. Cada caso de pruebas empieza con una palabra (`NORMAL` o `HTML`)
seguido de la descripción del color (tres enteros $0-255$ separados por
espacios en el primer caso, y siete caracteres de la forma $\#rrggbb$ en
el segundo).

## Salida

Para cada caso de pruebas, escribe la traducción del color descrito al
otro formato.

## Puntuación

- **TestA:**   Entradas cuyos casos de prueba sólo son de la forma
  `HTML`.

<!-- -->

- **TestB:**   Entradas cuyos casos de prueba sólo son de la forma
  `NORMAL`.

<!-- -->

- **TestC:**   Entradas con casos de prueba de ambos tipos.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T11:53:59.226Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
