# Substitució recursiva

Sigui $p$ una paraula amb només lletres '`a`', '`b`' i '`c`', i $n$ un
natural qualsevol. Considereu aquest procés: Tantes vegades com indiqui
$n$, reemplaceu alhora totes les '`c`' per la paraula $p$. Al final,
esborreu totes les '`c`'.

Per exemple, sigui $p =$ "`abcac`". Amb $n=0$, el resultat és
senzillament "`aba`". Amb $n=1$, obtenim "`ababaaaba`". Amb $n=2$,
obtenim "`abababaaabaaababaaaba`", etc. Aquesta figura indica el procés
de substitució amb $n=2$:

:::: center
::: pspicture
(15,8)

(6,7)a (6.5,7)b (7,7)c (7.5,7)a (8,7)c

(6,6.7)(4,4.3) (6.5,6.7)(4.5,4.3) (7,6.7)(6,4.3) (7.5,6.7)(7.5,4.3)
(8,6.7)(9,4.3)

(4,4)a (4.5,4)b (5,4) a (5.5,4) b (6,4) c (6.5,4) a (7,4) c (7.5,4)a
(8,4) a (8.5,4) b (9,4) c (9.5,4) a (10,4) c

(4,3.7)(0,1.3) (4.5,3.7)(0.5,1.3) (5,3.7)(1,1.3) (5.5,3.7)(1.5,1.3)
(6,3.7)(3,1.3) (6.5,3.7)(4.5,1.3) (7,3.7)(6,1.3) (7.5,3.7)(7.5,1.3)
(8,3.7)(8,1.3) (8.5,3.7)(8.5,1.3) (9,3.7)(10,1.3) (9.5,3.7)(11.5,1.3)
(10,3.7)(13,1.3)

(0,1)a (0.5,1)b (1,1)a (1.5,1)b (2,1) a (2.5,1) b (3,1) c (3.5,1) a
(4,1) c (4.5,1)a (5,1) a (5.5,1) b (6,1) c (6.5,1) a (7,1) c (7.5,1)a
(8,1)a (8.5,1)b (9,1) a (9.5,1) b (10,1) c (10.5,1) a (11,1) c (11.5,1)a
(12,1) a (12.5,1) b (13,1) c (13.5,1) a (14,1) c

(3.2,1.2)(2.8,0.8) (3.2,0.8)(2.8,1.2) (4.2,1.2)(3.8,0.8)
(4.2,0.8)(3.8,1.2) (6.2,1.2)(5.8,0.8) (6.2,0.8)(5.8,1.2)
(7.2,1.2)(6.8,0.8) (7.2,0.8)(6.8,1.2) (10.2,1.2)(9.8,0.8)
(10.2,0.8)(9.8,1.2) (11.2,1.2)(10.8,0.8) (11.2,0.8)(10.8,1.2)
(13.2,1.2)(12.8,0.8) (13.2,0.8)(12.8,1.2) (14.2,1.2)(13.8,0.8)
(14.2,0.8)(13.8,1.2)
:::
::::

Donades $p$ i $n$, escriviu el resultat final.

## Observació

*El vostre programa no pot fer servir cap vector o similar, i l'únic
string que pot usar és la paraula $p$ original, que no s'ha de modificar
per res. Qualsevol solució que no compleixi aquesta condició tindrà un 0
de qualificació.*

## Pista

Penseu una solució recursiva.

## Entrada

L'entrada consisteix en diversos casos, cadascun amb $p$ i $n$, amb
$n \ge 0$. Podeu suposar que la paraula $p$ només té lletres '`a`',
'`b`' i '`c`', i que té almenys alguna '`a`' o alguna '`b`'.

## Sortida

Per a cada cas, escriviu el resultat final del procés descrit.

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T12:21:15.888Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
