# IPv6

![image](ipv6.png){width="80%"}

Una dirección IPv6 es una secuencia de 8 grupos de 4 dígitos
hexadecimales, separados por dos puntos (:), como las siguientes:

> `ABCD:EF01:2345:6789:ABCD:EF01:2345:6789`\
> `2001:0DB8:0000:CD30:0000:0000:0000:0000`\
> `2002:0000:0000:00AA:0000:0000:0A00:0001`\
> `0000:0000:0000:0000:0000:0000:FFFF:FFFF`\
> `0000:0000:0000:0000:0000:0000:0000:0000`

En comparación con las antiguas direcciones IPv4, las direcciones IPv6
son tan largas que se han ideado las siguientes abreviaturas:

1.  Dentro de un grupo de 4 dígitos, borrar los ceros de delante
    (dejando siempre, como mínimo, un dígito).

2.  Una secuencia de 1 o más grupos de 4 ceros (`0000`) puede
    reemplazarse por dos caracteres dos puntos (::). Este reemplazo solo
    puede hacerse una vez en toda la dirección.

Por ejemplo, si aplicáramos la primera abreviatura las direcciones
anteriores quedarían:

> `ABCD:EF01:2345:6789:ABCD:EF01:2345:6789`\
> `2001:DB8:0:CD30:0:0:0:0`\
> `2002:0:0:AA:0:0:A00:1`\
> `0:0:0:0:0:0:FFFF:FFFF`\
> `0:0:0:0:0:0:0:0`

Y si además aplicásemos la segunda abreviatura (en nuestro caso,
reemplazando siempre el grupo de ceros más largo, y en caso de empate,
el de más a la izquierda) obtendríamos:

> `ABCD:EF01:2345:6789:ABCD:EF01:2345:6789`\
> `2001:DB8:0:CD30::`\
> `2002::AA:0:0:A00:1`\
> `::FFFF:FFFF`\
> `::`

En este problema te pedios que pases direcciones IPv6 de un formato
(abreviado o sin abreviar) a otro.

## Entrada

Cada entrada contiene varios casos. La primera línea de la entrada
contiene una letra (`C`, `1` o `2`) según si se te pide escribir la
dirección IPv6 en formato extendido (`C`), aplicar la primera
abreviatura (`1`), o las dos primeras abreviaturas (`2`).

La segunda línea de la entrada contiene el número $n$ de casos, no
superior a 1000. Las $n$ líneas restantes contienen direcciones IPv6 que
tienes que transcribir. Si se te pide `1` o `2`, recibirás una dirección
IPv6 sin abreviar, que deberás abreviar siguiendo las reglas descritas
anteriormente. (Para la segunda abreviatura, abrevia siempre la mayor
cantidad de ceros posible y, en caso de haber varias, abrevia el grupo
de ceros más a la izquierda, como se hace en el tercer ejemplo).

Si se te pide `C`, recibirás una dirección IPv6 abreviada (o
parcialmente abreviada) que deberás escribir en formato extendido (8
grupos de 4 dígitos hexadecimales).

## Salida

Para cada caso, escribe una única línea (acabada en salto de línea) con
la dirección IPv6, abreviada o sin abreviar, según se te pida.

## Puntuación

- **TestA:**

  Resolver varias entradas donde se te pide aplicar la primera
  abreviatura (`1`), como el Ejemplo 1.

<!-- -->

- **TestB:**

  Resolver varias entradas donde se te pide extender (`C`) direcciones
  IPv6 que no han sido abreviadas según la segunda norma (es decir, no
  contendrán `::`), como el Ejemplo 2.

<!-- -->

- **TestC:**

  Resolver varias entradas donde se te pide aplicar las dos primeras
  abrevituras (`2`), como el Ejemplo 3.

<!-- -->

- **TestD:**

  Resolver varias entradas donde se te pide extender (`C`) direcciones
  IPv6 de cualquier tipo, como el Ejemplo 4.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T12:20:49.312Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
