# F004A. Les capes de la ceba

![image](onion.png){width="3cm"} Donada una matriu, tots els elements
que es troben a la primera fila, a la primera columna, a l'última fila i
a l'última columna, formen la *primera capa* de la matriu. Igualment,
els elements que es troben a la segona fila, a la segona columna, a la
penúltima fila i a la penúltima columna (però que no es troben a la
primera capa), formen la *segona capa*. El concepte de capa es
generalitza de la mateixa manera per a tots els elements de la matriu.

Per exemple, per a una matriu de 8 files i 9 columnes, el diagrama
següent mostra a quina capa es troba cada element de la matriu:

:::: NoShortVerb
::: center
   1   1   1   1   1   1   1   1   1
  --- --- --- --- --- --- --- --- ---
   1   2   2   2   2   2   2   2   1
   1   2   3   3   3   3   3   2   1
   1   2   3   4   4   4   3   2   1
   1   2   3   4   4   4   3   2   1
   1   2   3   3   3   3   3   2   1
   1   2   2   2   2   2   2   2   1
   1   1   1   1   1   1   1   1   1
:::
::::

Feu un programa que, donades diferents matrius d'enters, calculi, per a
cadascuna d'elles, els valors mínims i màxims de cadascuna de les seves
capes. Per exemple, per a la matriu

:::: NoShortVerb
::: center
    15    1   92   92   82   15    1   92   92
  ---- ---- ---- ---- ---- ---- ---- ---- ----
    46   31   13    3   32   46   32   13   13
    15    3   32    2   22   16   12   34   14
    23   17   33    1    2   23   17   32   21
    13   63   56    2   21   13   62   66    4
    43    9    8   52   11   43    9    8   64
    53   96    6   42   17   63   99    6   14
    99   94    5   51   21   99   94    5   51
:::
::::

el mínim i màxim de la primera capa són 1 i 99, el mínim i màxim de la
segona capa són 3 i 99, el mínim i màxim de la tercera capa són 2 i 62,
i el mínim i màxim de la quarta capa són 1 i 23. Representem aquesta
informació amb un vector de parells:

:::: NoShortVerb
::: center
   1,99   3,99   2,62   1,23
  ------ ------ ------ ------
:::
::::

El programa principal ja se us dóna implementat (no el toqueu!).
Utilitzant els tipus

        struct Info {
            int min, max;
        };

        typedef vector<vector<int> > Matriu;

heu d'implementar la funció

        vector<Info> info_capes(const Matriu& mat);

que, donada una matriu rectangular \|mat\| (amb, com a mínim, una fila i
una columna), retorna un vector amb tantes posicions com capes té la
matriu, on la posició $i$ del vector conté els valors mínim i màxim de
la capa $i$+1 de \|mat\|.

## Informació del problema

Autoria: Professorat de P1

Generació: 2026-01-25T18:12:18.783Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
