# Dados raros

En este problema necesitarás números pseudo-aleatorios. Para generarlos,
usa la fórmula $$y_n = (75\cdot y_{n-1}) \ \text{mod } 65537,$$ donde
"$\text{mod}$" denota la operación de dividir y quedarse con el residuo
de la división, y $y_n$ es el $n$-ésimo número pseudo-aleatorio. El
número inicial $y_0$ (la semilla) se te dará por la entrada. Por
ejemplo, si $y_0=13$, los números que generarías serían $$\begin{align*}
y_1 &= (75\cdot 13) \ \text{mod } 65537 = 975, \\
y_2 &= (75\cdot 975) \ \text{mod } 65537 = 7588, \\
y_3 &= (75\cdot 7588) \ \text{mod } 65537 = 44804, \\
y_4 &= (75\cdot 44804) \ \text{mod } 65537 = 17913, \\
y_5 &= (75\cdot 17913) \ \text{mod } 65537 = 32735, \ldots
\end{align*}$$

Se te pide que uses una secuencia de números pseudo-aleatorios para
simular la tirada de un *dado* especial: el dado tiene $N$ caras ($N$ no
es necesariamente 6), y cada cara contiene un número (que no son
necesariamente los números del $1$ al $N$). Para saber qué cara
corresponde a un cierto número pseudo-aleatorio $y_i$, deberás calcular
$(y_i\ \text{mod }N)+1$ (el resultado es un número del $1$ al $N$).

## Entrada

Una línea con el número $n\leq 100$ de casos. A continuación, $n$
líneas, una por caso. Cada línea contiene, separados por espacios, el
número $y_0$ (la semilla), el número $1\leq k\leq 100$ de tiradas a
efectuar, el número $1<N\leq 100$ de caras del dado, y los $N$ números
que aparecen en las $N$ caras del dado.

## Salida

Para cada caso, tu programa debe escribir exactamente una línea de
salida, con las $k$ tiradas del dado que se obtienen de los números
$y_1$ hasta $y_k$. Separa dos números con una coma (sin espacios) y
finaliza la línea con un punto. Si tu programa no produce los números en
el formato descrito, no será considerado válido.

## Puntuación

- **TestA:**

  Resolver juegos de prueba como el del Ejemplo 1, donde se pide simular
  las tiradas de un único dado ($n=1$) de 6 caras $(N=6)$ con los
  números $1, 2, 3, 4, 5$ y $6$, en este orden.

<!-- -->

- **TestB:**

  Resolver juegos de prueba de todo tipo.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T12:13:06.591Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
