# Haskell --- Arbres binaris de cerca

Es vol tenir un mòdul per a arbres binaris de cerca (binary search
trees, BSTs) estàndards. Per això, es defineix el tipus següent:

        data BST a = E | N a (BST a) (BST a) deriving (Show)

Sobre aquest tipus cal crear les operacions següents:

- `insert :: Ord a => BST a -> a -> BST a`

  Retorna el resultat d'inserir un element en un arbre binari de cerca.
  Si l'element ja hi era, el resultat és l'arbre original.

- `create :: Ord a => [a] -> BST a`

  Retorna un arbre binari de cerca inserint l'un rera l'altre la llista
  d'elements donats.

- `remove :: Ord a => BST a -> a -> BST a`

  Retorna el resultat d'esborrar un element d'un arbre binari de cerca.
  Si l'element no hi era, el resultat és l'arbre original.

  (Nota: hi ha moltes maneres d'implementar l'esborrat; no importa quina
  trieu mentre sigui prou ràpida.)

- `contains :: Ord a => BST a -> a -> Bool`

  Indica si un element es troba o no en un arbre binari de cerca.

- `getmax :: BST a -> a`

  Retorna l'element més gran d'un arbre binari de cerca no buit.

- `getmin :: BST a -> a`

  Retorna l'element més petit d'un arbre binari de cerca no buit.

- `size :: BST a -> Int`

  Retorna el nombre d'elements en un arbre binari de cerca.

- `elements :: BST a -> [a]`

  Retorna els elements d'un arbre binari de cerca en ordre.

## Puntuació

- **test-1:**   Funció *insert*.

<!-- -->

- **test-2:**   Funció *create* i les anteriors.

<!-- -->

- **test-4:**   Funcions *getmin* i *getmax* i les anteriors.

<!-- -->

- **test-3:**   Funció *contains* i les anteriors.

<!-- -->

- **test-5:**   Funcions *elements* i *size* i les anteriors.

<!-- -->

- **test-6:**   Funció *remove* i les anteriors.

<!-- -->

- **test-7:**   Tests d'eficiència, genericitat i integritat amb totes
  les funcions.

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-02-03T16:59:58.104Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
