# Españistán

¡Que ardilla tan bonita! ¡Y que bosques! ¿Porque no aprovechamos para
construir unos cuantos apartamentos por la zona?

Un terreno consiste en una secuencia de números, con las alturas de cada
parcela de terreno. Para construir los apartamentos necesitamos
*allanar* un subsecuencia consecutiva de parcelas (un solar) moviendo
tierra de una parcela a otro del solar, hasta conseguir que todas las
parcelas tengan la misma altura. El siguiente ejemplo muestra como
formar un solar de 5 parcelas en un terreno de 9 parcelas.

::::: center
::: pspicture
(9,4) (0,0) (0,0)(1,0) (1,2)(2,2) (2,0)(3,0) (3,3)(4,3) (4,2)(5,2)
(5,1)(6,1) (6,3)(7,3) (7,1)(8,1) (8,2)(9,2) (9,0)(0,0) (3,-0.3)(3,3.3)
(8,-0.3)(8,3.3)
:::

::: pspicture
(9,4) (0,0) (0,0)(1,0) (1,2)(2,2) (2,0)(3,0) (3,2)(4,2) (4,2)(5,2)
(5,1)(6,1) (6,2)(7,2) (7,1)(8,1) (8,2)(9,2) (9,0)(0,0)
(3,2)(3,3)(4,3)(4,2) (5,1)(5,2)(6,2)(6,1)(5,1) (6,2)(6,3)(7,3)(7,2)
(7,1)(7,2)(8,2)(8,1)(7,1) (3,-0.3)(3,3.3) (8,-0.3)(8,3.3)
:::
:::::

Para allanar un solar sólo puedes *mover* unidades de tierra de las
parcelas que pertenece al mismo, y retirar tierra del solar. Este último
proceso es muy caro (y los malditos ecologistas se te tiran al cuello)
por lo que interesa tener que retirar la mínima cantidad de unidades de
tierra. Si en el ejemplo anterior hubiéramos intentado allanar el solar
situado dos parcelas más a la izquierda, hubiéramos tenido que mover una
1 unidad y retirar otras 3.

::::: center
::: pspicture
(9,4) (0,0) (0,0)(1,0) (1,2)(2,2) (2,0)(3,0) (3,3)(4,3) (4,2)(5,2)
(5,1)(6,1) (6,3)(7,3) (7,1)(8,1) (8,2)(9,2) (9,0)(0,0) (1,-0.3)(1,3.3)
(6,-0.3)(6,3.3)
:::

::: pspicture
(9,4) (0,0) (0,0)(1,0) (1,1)(2,1) (2,0)(3,0) (3,1)(4,1) (4,1)(5,1)
(5,1)(6,1) (6,2)(7,2) (7,1)(8,1) (8,2)(9,2) (9,0)(0,0)
(1,1)(1,2)(2,2)(2,1) (3,1)(3,3)(4,3)(4,1) (4,1)(4,2)(5,2)(5,1)
(2,0)(2,1)(3,1)(3,0)(2,0) (1,-0.3)(1,3.3) (6,-0.3)(6,3.3)
:::
:::::

Te pedimos que hagas un programa que, dadas las alturas de un terreno de
tamaño $n$, descubra cuál es el mejor lugar para formar un solar de
tamaño $s$. En concreto, buscamos aquel solar tal que:

- Haya que transportar fuera del solar la menor cantidad de tierra
  posible.

- En caso de empate, que se tenga que mover dentro del solar la menor
  cantidad de unidades de tierra.

- En caso de empate, que el solar esté tan a la izquierda del terreno
  como sea posible.

## Entrada

Cada entrada contiene un único caso de prueba, formado por dos líneas.
La primera línea contiene el tamaño $n$ del terreno, el tamaño $0<s<n$
del solar que queremos construir, y una altura $t$ mayor que las alturas
de todas las parcelas. La segunda línea contiene $n$ números enteros
entre $0$ y $t-1$ (ambos inclusive) con las alturas de las $n$ parcelas.

## Salida

Escribe dos líneas. En la primera línea, escribe los índices de la
primera y la última parcela del mejor solar de tamaño $s$ (empezando a
contar por $1$), y en la segunda, el número de unidades de tierra que es
necesario retirar del solar propuesto, y el número de unidades de tierra
que hay que mover de un sitio a otro del solar para que éste quede
llano.

## Puntuación

- **Test1:**

  Resolver varias entradas donde $n, s\le 100, t\le 2$.

<!-- -->

- **Test2:**

  Resolver varias entradas donde $n, s\le 100, t\le 10$.

<!-- -->

- **Test3:**

  Resolver varias entradas donde $n\le 100000, s\le 100, t\le 10$.

<!-- -->

- **Test4:**

  Resolver varias entradas donde $n, s\le 100000, t\le 10$.

<!-- -->

- **Test5:**

  Resolver varias entradas donde $n, s, t\le 100000$.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T12:10:12.309Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
