# Dibujando Ventanas

Te han contratado para que programes el gestor de ventanas del nuevo
sistema operativo favorito de todo el mundo, el Windows Vista-ZO. La
pantalla del nuevo Windows es un plano cuadriculado virtualmente
infinito; la parte visible de la pantalla es un recuadro rectangular de
40 por 10 bloques. La cuadrícula que ocupa la esquina inferior izquierda
de la parte visible tiene coordenadas $(0,0)$, la superior derecha tiene
coordenadas $(39, 9)$. Los bloques de la pantalla pueden estar vacíos
(esto se marca con el carácter `.`) u ocupados por una ventana.
Inicialmente la pantalla está vacía y el cursor ocupa la posición
$(0,9)$.

Las ventanas se dibujan una detrás de otra. Una ventana ocupa
(sobreescribe) los bloques que pudiera ocupar una ventana anterior. Cada
ventana es una región rectangular que debe dibujarse del siguiente modo
(los ejemplos de la página siguiente facilitan la comprensión):

- Las cuatro esquinas del marco de la ventana tienen los caracteres `#`.

- Las paredes verticales del marco tienen los caracteres `!`.

- La pared superior del marco (la barra de títulos) tiene los caracteres
  `=`.

- La pared inferior del marco tiene los caracteres `-`.

- El interior de la ventana se llena con uno de los caracteres `1`, `2`,
  $\ldots$, `9`, `0`: en concreto, el interior de la ventana $i$-ésima
  se llena con el carácter $i \mod 10$, es decir, el resto de la
  división de $i$ entre $10$.

Tu cometido es hacer un programa que dibuje cómo quedaría la parte
visible de la pantalla después de que se ejecuten diversas órdenes de
dibujado de ventanas. En particular, las órdenes posibles son:

- `MOV <x> <y>`: la posición del cursor pasa a ser $(x, y)$.

- `MOVREL <rx> <ry>`: la posición del cursor se incrementa en $(rx, ry)$
  (por ejemplo, si $rx=0$ y $ry=-3$, la coordenada $x$ del cursor no se
  modifica, y la coordenada $y$ del cursor se decrementa en 3 unidades).

- `DRAW <sx> <sy>`: dibuja una ventana, cuya esquina superior izquierda
  está en la posición del cursor, de $sx$ columnas y $sy$ filas. Toda
  ventana es tal que $3\le sx \le 40$ y $3\le sy \le 10$. La posición
  del cursor no se modifica.

El cursor puede desplazarse fuera de la pantalla; las ventanas dibujadas
no tienen porqué empezar a dibujarse dentro de la pantalla, y no tienen
porqué caber dentro de la pantalla en su totalidad.

## Entrada

La primera línea contiene el natural $n\ge 0$ (el número total de casos
a tratar). Cada caso consiste en una línea con el natural $m\ge 0$ (el
número de órdenes a ejecutar) seguido de $m$ líneas, cada una de las
cuales contiene una orden a ejecutar, siguiendo el formato descrito
anteriormente. Durante el transcurso de las órdenes de dibujo, las
coordenadas del cursor siempre cumplen $|x|<10^6$ y $|y|<10^6$.

## Salida

Tu programa debe imprimir 10 líneas de 40 caracteres por cada caso a
tratar. Separa dos casos con una línea que contenga únicamente una coma
(`,`). Por lo tanto, si $n>0$ la salida debe tener exactamente
$10n+(n-1)$ líneas.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T12:08:56.883Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
