# Celebrity

In a party, we say that $c$ is a celebrity if everybody knows $c$, but
$c$ knows nobody. (We do not care if $c$ knows himself or herself.)
Please write a program to tell if a party has a celebrity.

The party has $n$ persons, each with a first name $f_i$ and a surname
$s_i$. All those $2n$ strings have the same length $m$, and implicitly
tell who knows who in a funny way. Given two characters $a$ and $b$, let
us define the "distance" between them as
$d(a, b) = (a - b + 12) \bmod 26 - 12$. Observe that
$-12 \le d(a, b) \le 13$. Now, given a first name $f_i$ and a surname
$s_j$, let us define the "total distance" between them as
$t(f_i, s_j) = \sum_{0 \le k < m} d(f_i[k], s_j[k])$. Then, $i$ knows
$j$ if and only if $t(f_i, s_j) > 0$.

For instance, consider a small party with two persons with short names:
Li Hu and No Hi. Since $d(`\texttt{\small L}', `\texttt{\small H}') = 4$
and $d(`\texttt{\small i}', `\texttt{\small i}') = 0$, we have
$t(``\texttt{\small Li}'', ``\texttt{\small Hi}'') = 4 > 0$, so Li Hu
does know No Hi. By contrast,
$t(``\texttt{\small No}'', ``\texttt{\small Hu}'') = 0$, so No Hi does
not know Li Hu.

## Input

Input consists of several cases. Every case begins with $n$, followed by
$n$ names (first name and surname). All the given strings have the same
length $m$. The first letter of each string is uppercase, the rest are
lowercase. First names and surnames can be repeated, but the composition
of them uniquely identifies one person. Assume $2 \le n \le 10^5$ and
$2 \le m \le 6$.

## Output

Print one line for every case. If the party has no celebrity, print
"`No`". If the party has one celebrity, print his or her name. If the
party has more than one celebrity, print "`I should learn some logic`".

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T12:07:50.850Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
