# Pillars

The world-famous architect Mr. Fruí from Reus is planning to build a
colossal pillar $H$ units high. Mr. Fruí has $n$ black pieces with
heights $b_1, \dots, b_n$, and $m$ white pieces with heights
$w_1, \dots, w_m$. According to his design, the pillar must have four
pieces: a black piece at its bottom, a white piece above it, another
black piece above, and finally a white piece at the top of the pillar.

Mr. Fruí wishes to know which combination of four pieces with total
height $H$ is the most stable. Given two combinations
$A = [a_1, a_2, a_3, a_4]$ and $B = [b_1, b_2, b_3, b_4]$ (where $a_1$
denotes the height of the bottom (black) piece of the pillar $A$, $a_2$
denotes the height of the second (white) piece of $A$, and so on), we
say that $A$ is more stable than $B$ if $a_1 > b_1$, or if $a_1 = b_1$
but $a_2 > b_2$, etc. In other words, $A$ is more stable than $B$ if and
only if the sequence of heights of the pieces of $A$ is
lexicographically larger than the sequence of heights of the pieces of
$B$.

Write a program such that, given the desired height $H$ of the pillar,
the heights of the black pieces and the heights of the white pieces,
computes which pillar (if any) of height exactly $H$ would be the most
stable.

## Input

Input consists of several cases, each in three lines. The first line has
$H$, an integer number between 1 and $4 \cdot 10^8$. The second and
third lines consist respectively of $b_1, \dots, b_n$ and of
$w_1, \dots, w_m$. A blank line separates two cases. Assume
$2 \le n \le 1000$ and $2 \le m \le 1000$, and that no piece has a
height larger than $10^8$.

## Output

For every case, print the sequence of heights of the pieces of the most
stable pillar, from bottom to top. If no solution exists, print
"`no solution`".

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T12:06:35.733Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
