# Sudoku

Write a program in Python that, using the **optilog** library, solves a
given sudoku.

In order to use the optilog library, the program has to include
something like:

    from optilog.solvers.sat import *
    ...
    solver = Glucose41()
    solver.add_clauses(...)
    solver.solve()
    solver.model()

## Input

The input is a text (in the stdin) with numbers (between 1 and 9) in
some cells, and dots \".\" in the empty cells. For instance, the text:

    53..7....
    6..195...
    .98....6.
    8...6...3
    4..8.3..1
    7...2...6
    .6....28.
    ...419..5
    ....8..79

## Output

The output is also a text (in the stdout) only with numbers between 1
and 9 that represents the solution. In this example:

    534678912
    672195348
    198342567
    859761423
    426853791
    713924856
    961537284
    287419635
    345286179

If the problem has no solution, the output must be the sentence: **NO
SOLUTION**

If the problem has multiple solutions, the output must be the sentence:
**MULTIPLE SOLUTIONS**

## Scoring

If your program is able to solve correctly sudokus with just one
solution, the score will be 5. If additionally, you detect unsolvable
problems, you will get 2 additional points, and 3 more if you can detect
problems with multiple solutions.

## Problem information

Author: Jordi Levy

Generation: 2026-01-25T12:04:58.840Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
