#include <iostream>
#include <vector>
using namespace std;


class atzar {
  private:

  static const long long MOD = ((long long)1)<<31;
  static const long long MASC = MOD - 1;

  long long llavor;

  void seguent() {
    llavor = (843314861*llavor + 453816693)&MASC;
  }

  public:

  // inicialitza la llavor amb el valor donat
  atzar(int seed) : llavor(seed) { llavor &= MASC; }

  // retorna un real aleatori de [0, 1)
  double uniforme() {
    seguent();
    return double(llavor)/MOD;
  }

  // retorna un enter aleatori de [esquerra, dreta], fins a 2^31 - 1
  int uniforme(int esquerra, int dreta) {
    return esquerra + (int)((double(dreta) - esquerra + 1)*uniforme());
  }
};


atzar A(0);


int mistery(const vector<int>& C, const vector<int>& D);


int main() {
  int n, e1, d1, e2, d2, q1, q2;
  while (cin >> n >> e1 >> d1 >> e2 >> d2 >> q1 >> q2) {
    vector<int> C(n, e1), D(n, e2);

    if (d1 != -1)
      for (int i = 0; i < n; ++i) C[i] = A.uniforme(e1, d1);
    if (d2 != -1)
      for (int i = 0; i < n; ++i) D[i] = A.uniforme(e2, d2);

    while (q1--) {
      int i, x;
      cin >> i >> x;
      C[i] = x;
    }
    while (q2--) {
      int i, x;
      cin >> i >> x;
      D[i] = x;
    }

    int rep = (n > 1000 ? 100 : 1);
    while (rep--) cout << mistery(C, D) << endl;
  }
}
