# Pòker

Simuleu una partida de pòker, amb les regles simplificades que
s'expliquen a continuació.

La baralla té 52 cartes. Cada carta té un de 13 valors, i pertany a un
de quatre pals. Els valors es representen, en ordre decreixent, amb
`A K Q J D 9 8 7 6 5 4 3 2`. Els quatre pals són cors, diamants, piques
i trèbols, i es representen amb les inicials `C D P T`.

Tenim 10 jugadors, anomenats en ordre `A`, ..., `J`. De les 52 cartes,
repartides en un cert ordre, `A` en rep les cincs primeres, `B` en rep
les cincs següents, etc. Les dues últimes cartes no s'usen. Les
combinacions que pot obtenir cada jugador, de més a menys importants,
són:

- Escala de color: Color i escala alhora.

- Pòker: quatre cartes del mateix valor.

- Full: tres cartes del mateix valor, i dues cartes del mateix valor.

- Color: Totes les cartes del mateix pal.

- Escala: Les cinc cartes amb valors consecutius. `A` i `2` **no**
  enllacen circularment.

- Trio: tres cartes del mateix valor, i les altres dues de valors
  diferents.

- Doble parella: dues cartes del mateix valor, dues cartes del mateix
  valor (diferent), i l'altra d'un valor diferent als dos anteriors.

- Parella: dues cartes del mateix valor, i les altres tres de valors
  diferents.

- Res: Cap de les anteriors, és a dir, cinc valors diferents, sense
  color ni escala.

Si dos (o més) jugadors obtenen combinacions de la mateixa importància,
es desempata com s'indica a continuació. Per claredat, es mostren els
exemples amb les cartes de cada jugador ordenades, encara que no importi
l'ordre en què s'obtinguin les cartes.

- Escala de color: Guanya la carta més alta (la de més valor). Per
  exemple, `QD JD DD 9D 8D` guanya a `JC DC 9C 8C 7C`.

- Pòker: Es comparen les cartes dels pòkers. Per exemple,
  `8C 8D 8P 8T 3P` guanya a `4C 4D 4P 4T AC`.

- Full: Es comparen les cartes dels trios. Per exemple, `JC JD JT 4P 4T`
  guanya a `9C 9P 9T AD AP`.

- Color: Guanya la carta més alta, fins a trobar una diferència en cas
  d'empat. Per exemple, `KC JC 9C 3C 2C` guanya a `KT JT 8T 7T 6T`.

- Escala: Guanya la carta més alta. Per exemple, `9D 8T 7C 6C 5P` guanya
  a `6P 5D 4D 3D 2D`.

- Trio: Es comparen les cartes dels trios. Per exemple, `8C 8P 8T 7T 3P`
  guanya a `4C 4D 4T AT KC`.

- Doble parella: Es comparen les parelles més valuoses. En cas d'empat,
  es comparen les parelles menys valuoses. En cas d'un altre empat, es
  comparen les cartes aïllades. Per exemple, `KC KT 2C 2P 5T` guanya a
  `DD DP 8D 8T AD`.

- Parella: Es comparen les parelles. En cas d'empat, guanya la carta més
  alta, fins a trobar una diferència. Per exemple, `QC QT AP 9D 3T`
  guanya a `QD QP AC 8D 7T`.

- Res: Guanya la carta més alta, fins a trobar una diferència en cas
  d'empat. Per exemple, `QD DT 7D 4C 3C` guanya a `QC DP 6C 5T 4P`.

Si dos (o més) jugadors segueixen empatats després d'aquestes
consideracions, sempre es desempata a favor del jugador amb el nom més
petit en ordre alfabètic.

## Entrada

L'entrada consisteix en el nombre de casos $n$, seguit d'$n$
permutacions de les 52 cartes. Cada carta es representa amb dos
caràcters consecutius, tal i com s'ha explicat. Tant els casos com les
cartes poden venir separats per diversos espais i línies buides.

## Sortida

Per a cada cas, escriviu una línia amb els jugadors ordenats segons el
valor de les seves cartes (de més a menys), separats amb espais.

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T11:57:26.994Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
