# Coronavirus

Volem simular, amb un model ridículament senzill, la contaminació i els
contagis que pot produir a un aula de la facultat l'esternut d'un
estudiant possiblement infectat de covid-19.

Al nostre model el mapa de cada aula es representa per una matriu de $n$
files i $m$ columnes, on cada posició $(i,j)$ representa una cadira
($0\leq i < n$, $0\leq j < m$). La posició $(i,j)$ de la matriu es marca
amb una lletra \@e@ per tal de indicar que a la cadira $(i,j)$ s'asseu
un estudiant i amb un punt si la cadira està buida.

Assumirem que un dels estudiants de l'aula, assegut a la posició
$(i,j)$, esternuda. L'esternut fa que el virus es propagui en direcció
horitzontal (cap a columnes posteriors a la seva) fins a una distància
màxima $h\geq1$, proporcional a la força de l'esternut . A més,
l'esternut produeix aerosols que s'expandeixen i contaminen de virus
tota l'àrea d'un triangle isòsceles amb àpex a $(i,j)$ i alçada $h$, tal
i com es mostra a la figura --a on l'esternut es produeix a la cadira
vermella, amb distància màxima $h=6$.

![image](esternut.png){width="8.5cm"}

Feu un programa que, donats el mapa d'ocupació d'una aula concreta,
determini quina és l'àrea que queda contaminada i quants estudiants es
contagiaran (en el pitjor cas) en simular diferents possibles posicions
de l'esternut. El vostre programa ha d'incloure **obligatòriament** la
següent funció:

        int contagia(Aula& M, int i, int j, int h);

que, donat el mapa de l'aula `M`, la posició `(i,j)` de l'esternut, i la
distància màxima d'expansió `h`, retorna el nombre d'estudiants que es
contagiaran i marca a `M` l'àrea que ha quedat contaminada amb @\*@. Els
estudiants que es trobin dins de l'àrea contaminada canviaran la \@e@
per una \@I@.

El tipus `Aula` es defineix de la següent forma:

        using Aula = vector<string>;

## Entrada

L'entrada consisteix d'un parell d'enters $n$ i $m$, $0 < n,m\leq 100$,
seguits d'un mapa d'aula de $n\times m$ de caràcters en què un @.@
indica un seient lliure i una \@e@ indica un seient ocupat per un
estudiant. A continuació segueix una seqüencia de tuples de 3 elements.
Cada tupla conté un parell d'enters $i,j$ que indiquen la posició de
l'esternut dins de l'aula ($0\leq i < n$ i $0\leq j < m$), i un enter
$h\geq 1$ que determina la distància màxima d'expansió de l'esternut.

## Sortida

Sobre el mapa inicial de l'aula, cal determinar, per a cada $3$-tupla de
la seqüència, quina és l'àrea que quedaria contaminada de virus i quants
estudiants es podrien arribar a contagiar, seguint el format dels
exemples. Després de la simulació cada $3$-tupla de la seqüència, hi ha
una línia de separació formada per vint guions @-@.

## Observació

Les simulacions son independents entre elles, per tant heu d'utilitzar
el mapa d'entrada de l'aula abans de realitzar cada simulació.

## Informació del problema

Autoria: Maria Blesa i Amalia Duch

Generació: 2026-01-25T11:51:10.180Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
