# Haskell --- Arbres AVL

Si ja heu fet el problema dels Arbres Binaris de Cerca, ara us podeu
lluïr extenent la vostra implementació a Arbres AVL. En aquest problema
es demana que definiu operacions per inserir en AVLs i per comprovar-ne
la correctesa.

Per als AVLs, es defineix el tipus següent:

        data AVL a
            = E | N a Int (AVL a) (AVL a)        -- l'enter guarda l'alçada
            deriving (Show)

Sobre aquest tipus cal crear les operacions següents:

- `insert :: Ord a => AVL a -> a -> AVL a`

  Retorna el resultat d'inserir un element en un arbre AVL. Si l'element
  ja hi era, el resultat és l'arbre original.

- `create :: Ord a => [a] -> AVL a`

  Retorna un arbre AVL tot inserint un rera l'altre la llista d'elements
  donats.

- `check :: AVL a -> (Bool,Int)`

  Donat un arbre, si és AVL, retorna cert i la seva alçada; si no és
  AVL, retorna fals i -99.

  Els arbres buits es consideren d'alçada -1, les fulles és consideren
  d'alçada zero, \...);

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-02-03T16:59:48.190Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
