# Rachael's clons

0.70

Dr. Eldon Tyrell is studying the endurance of Nexus-6 replicants. He has
constructed many identical Rachaels, so he can do this experiment as
many times as he likes: He enters with a Rachael into an elevator, goes
up to a height of $x$ meters (this costs $c x$ dollars in energy for
some constant $c$), and pushes Rachael so that it falls down. If Rachael
breaks, Dr. Tyrell loses its value ($v$ dollars). Otherwise, Dr. Tyrell
loses nothing (but implants a new memory to Rachael so that it does not
take revenge!).

Dr. Tyrell already knows that Rachaels break when they fall from a
height of $H$ meters (an integer number), but now he wants to discover
the minimum height $h$ at which they break, assuming that $h$ is also
integer. Dr. Tyrell wants to save as much money as possible.
(Ingenuously, because the renegade Nexus-6 Roy Batty is going to crush
its creator's head very soon...)

  0.30

::: center
![image](rachael.eps){width="4.2cm"}
:::

Help Dr. Tyrell in this two settings: (1) in the worst case; (2) in the
average case, supposing that any height $1, 2, \dots, H$ has the same
probability of being $h$.

For instance, let $H = 4$, $c = 2$ and $v = 5$. Here, the optimal
strategy to minimize the worst-case cost of discovering $h$ starts
dropping a Rachael from height 2. If the replicant does not break, we
drop it again from height 3; otherwise, we drop another Rachael from
height 1. The worst cost happens when both replicants break, for a total
cost of $2 \cdot 2 + 5 + 2 \cdot 1 + 5 = 16$.

With the same values, the optimal strategy to minimize the average-case
cost starts dropping a Rachael from height 1. With probability $1/4$ it
will break, in which case we discover that $h = 1$. If it does not
break, we drop it again from height 2, and again from height 3 if
necessary. Therefore, the average cost of this strategy is
$$2 \cdot 1 + \frac{1}{4} \cdot 5
+ \frac{3}{4}
\left( 2 \cdot 2 + \frac{1}{3} \cdot 5
       + \frac{2}{3} \Big( 2 \cdot 3 + \frac{1}{2} \cdot 5 \Big)
\right)
= 11.75 .$$

## Input

Input consists of several cases, each one with three integer numbers
$H$, $c$ and $v$. Assume $1 \le H \le 100$, $0 \le c \le 100$ and
$0 \le v \le 100$.

## Output

For every case, print the minimum cost to discover $h$, in the worst
case (an integer number), and also in the average case (a real number
with four digits after the decimal point). The input cases have no
precision issues.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T12:02:44.327Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
