# Blackjack (Interactivo)

ESTE PROBLEMA NO FUNCIONA AUN.

Haz un programa que juegue al Blackjack (un sencillo pero popular juego
de cartas). !'Cuánto mejor lo haga, más puntos recibirás!

*A diferencia de los restantes problemas de la OIE, donde tu programa
debe calcular la salida correcta a una entrada dada, este problema es
*interactivo*: la entrada que reciba tu programa cambiará en función de
lo que responda.*

Estas son las reglas del Blackjack:

- Baraja francesa (de poker) con 52 cartas: 13 números (`A`, 2, ..., 9,
  10, `J`, `Q`, `K`) de 4 palos distintos.

- El objetivo del juego es sumar tantos puntos como sea posible, sin
  superar nunca 21.

- Los valores de las cartas son: su número; o 10 si la carta es `J`, `Q`
  o `K`; o 1 ó 11 si la carta es `A`.

- Los puntos de un jugador es la suma de los valores de sus cartas,
  contabilizando los ases como 11 o 1 según convenga para tener la
  máxima puntuación posible, sin exceder 21. Por ejemplo: el valor de
  `A`, `9` es 20, el calor de `A`, `A`, `9` es 21, y el valor de `A`,
  `A`, `A`, `9` es 12.

- Primero juegas tu: puedes ir pidiendo cartas (`CARTA`), una a una,
  hasta plantarte (`STOP`) o sumar 21 o más.

- A continuación juega la banca, que siempre pide cartas hasta conseguir
  sumar 16 o más puntos.

- Si tus cartas suman más de 21 (te pasas), gana la banca (sin importar
  los puntos que ésta tenga). Si la banca se pasa y tú no, ganas tú. Si
  ninguno de los dos se ha pasado, gana quien tenga más puntos, o se
  empata si ambos tienen la misma puntuación.

Además de estas reglas, jugaremos la partida de Blackjack con unas
normas adicionales.

- Se juega con 1 barajas de 52 cartas. Cuando una partida acaba, la
  siguiente empieza con las cartas que todavía no se han repartido *de
  la misma baraja*. Si a mitad de una partida se acaban las cartas, se
  sigue jugando con una baraja nueva.

- Al empezar la partida la banca te reparte dos cartas (una descubierta,
  y una tapada) y se reparte dos cartas (una descubierta, y una tapada).

- En ese instante puedes decidir la cantidad de tu apuesta: 1 o 2
  fichas.

- Después de apostar, se destapará tu carta tapada, y podrás decidir si
  seguir o no. Cuando acabe tu turno, se destapará la carta tapada de la
  banca, y ésta podrá decidir si seguir o no.

Conociendo estas normas tal vez puedas programar un jugador más bueno:

- Cuenta las cartas que quedan sin repartir en la baraja para saber qué
  es más probable que ocurra.

- En función de las cartas destapadas, decide si es conveniente apostar
  1 o 2 fichas.

Tu jugador de Blackjack leerá la entrada para saber qué está pasando en
la partida, y escribirá en la salida para decir cuánto quiere apostar, y
cuándo quiere plantarse.

### Entrada/Salida

Mira este ejemplo con 2 partidas. Las líneas con `>` indican *entrada*
que tu programa debe leer, y las líneas con `<` son ejemplos de *salida*
que tu programa podría haber escrito.

`> PARTIDA`\
`> JUGADOR 10`\
`> JUGADOR TAPADA`\
`> BANCA 5`\
`> BANCA TAPADA`\
`> APUESTA 1/2 ?`\
`< APUESTA 1`\
`> JUGADOR Q`\
`> TOTAL 20 CARTA/STOP ?`\
`< STOP`\
`> BANCA 7`\
`> BANCA A`\
`> BANCA 4`\
`> RESULTADO 1`\
`> PARTIDA`\
`> JUGADOR A`\
`> JUGADOR TAPADA`\
`> BANCA J`\
`> BANCA TAPADA`\
`> APUESTA 1/2 ?`\
`< APUESTA 2`\
`> JUGADOR 6`\
`> TOTAL 17 CARTA/STOP ?`\
`< CARTA`\
`> JUGADOR 6`\
`> TOTAL 13 CARTA/STOP ?`\
`< CARTA`\
`> JUGADOR J`\
`> BANCA 8`\
`> RESULTADO -2`\
`> FINAL -1`\

Una carta se representa por su figura (`A`, 2, ..., 10, `J`, `Q` o `K`).
El texto `JUGADOR X` o `BANCA X` indica que tu jugador (o la banca)
recibe la carta `X`.

Cada partida empieza con el texto `PARTIDA`. A continuación se reparten
dos cartas a cada jugador, la segunda de las cuales está `TAPADA`, y se
te pregunta la apuesta (`APUESTA 1/2 ?`), a lo que deberás responder
**`APUESTA 1`** o **`APUESTA 2`**. Luego se te reparten cartas. Después
de cada carta, y siempre que tu puntuación no llegue a `21`, se te
pregunta `TOTAL X CARTA/STOP?`, donde `X` es el valor de tus cartas (si
hay ases, el máximo valor de tus cartas sin superar 21). A cada
pregunta, deberás respondar **`CARTA`** o **`STOP`**. No te olvides de
escribir un salto de línea.

Una vez acabe tu turno, juega la banca, que recibirá cartas hasta
igualar o superar 16. La última línea de la partida es `RESULTADO X`,
donde `X` será, en función de la apuesta, $-2$ o $-1$ si pierdes, $1$ o
$2$ si ganas, y $0$ si empatas. La última línea de toda la entrada
contendrá `FINAL X`, donde `X` es la puntuación total de tu programa.
Cuando esto ocurra, tu programa deberá finalizar.

Para poder probar que tu programa funciona correctamente, puedes usar
los archivos `blackjack.exe`, `conn.py` y `entrada.txt` que tienes a tu
disposición. Escribiendo

`python conn.py ./programa.exe entrada.txt`

donde `./programa.exe` es el nombre de tu ejecutable, tu programa se
ejecutará tantas veces como indique la primera línea del archivo de
texto `entrada.txt`. También puedes jugar manualmente tú contra la
banca, para estudiar como es la entrada y salida, escribiendo

`./blackjack.exe entrada.txt`

## Puntuación

Tu programa jugará exactamente 10000 partidas contra la banca. La
puntuación de tu programa dependerá de las apuestas que gane:

- **10-30 Puntos.** Acabar con entre $-20000$ y $-1000$ fichas.

- **30-70 Puntos.** Acabar con entre $-1000$ y $0$ fichas.

- **70-100 Puntos.** Acabar con entre $0$ y $1000$ fichas.

En caso de estar entre dos puntuaciones, tu programa recibirá el valor
intermedio que corresponda, redondeando hacia abajo. Por ejemplo, un
programa que acabe con `FINAL -500` recibirá 50 puntos.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T12:02:37.546Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
