# Counting trees

Masao Long-Long, an Asian mathematician, is studying general rooted
trees. Below you can see some examples. Every node shows the size (the
number of nodes) of the subtree rooted at it.

$$\begin{array}[4]{cccc}

\pstree[levelsep=25pt,treesep=12pt]
{\Tcircle{\mbox{\scriptsize 4}}}{
  \Tcircle{\mbox{\scriptsize 1}}
  \pstree{\Tcircle{\mbox{\scriptsize 2}}}
  {
    \Tcircle{\mbox{\scriptsize 1}}
  }
}

&

\quad
\pstree[levelsep=25pt,treesep=12pt]
{\Tcircle{\mbox{\scriptsize 9}}}{
  \pstree{\Tcircle{\mbox{\scriptsize 4}}}
  {
    \pstree{\Tcircle{\mbox{\scriptsize 3}}}
    {
      \pstree{\Tcircle{\mbox{\scriptsize 2}}}
      {
        \Tcircle{\mbox{\scriptsize 1}}
      }
    }
  }
  \pstree{\Tcircle{\mbox{\scriptsize 4}}}
  {
    \pstree{\Tcircle{\mbox{\scriptsize 3}}}
    {
      \pstree{\Tcircle{\mbox{\scriptsize 2}}}
      {
        \Tcircle{\mbox{\scriptsize 1}}
      }
    }
  }
}

&

\quad
\pstree[levelsep=25pt,treesep=12pt]
{\Tcircle{\mbox{\scriptsize 15}}}{
  \pstree{\Tcircle{\mbox{\scriptsize 7}}}
  {
    \pstree{\Tcircle{\mbox{\scriptsize 3}}}
    {
      \pstree{\Tcircle{\mbox{\scriptsize 2}}}
      {
        \Tcircle{\mbox{\scriptsize 1}}
      }
    }
    \pstree{\Tcircle{\mbox{\scriptsize 3}}}
    {
      \pstree{\Tcircle{\mbox{\scriptsize 2}}}
      {
        \Tcircle{\mbox{\scriptsize 1}}
      }
    }
  }
  \pstree{\Tcircle{\mbox{\scriptsize 7}}}
  {
    \pstree{\Tcircle{\mbox{\scriptsize 2}}}
    {
      \Tcircle{\mbox{\scriptsize 1}}
    }
    \pstree{\Tcircle{\mbox{\scriptsize 2}}}
    {
      \Tcircle{\mbox{\scriptsize 1}}
    }
    \pstree{\Tcircle{\mbox{\scriptsize 2}}}
    {
      \Tcircle{\mbox{\scriptsize 1}}
    }
  }
}

&

\quad
\pstree[levelsep=25pt,treesep=12pt]
{\Tcircle{\mbox{\scriptsize 22}}}{
  \pstree{\Tcircle{\mbox{\scriptsize 7}}}
  {
    \pstree{\Tcircle{\mbox{\scriptsize 3}}}
    {
      \pstree{\Tcircle{\mbox{\scriptsize 2}}}
      {
        \Tcircle{\mbox{\scriptsize 1}}
      }
    }
    \pstree{\Tcircle{\mbox{\scriptsize 3}}}
    {
      \pstree{\Tcircle{\mbox{\scriptsize 2}}}
      {
        \Tcircle{\mbox{\scriptsize 1}}
      }
    }
  }
  \pstree{\Tcircle{\mbox{\scriptsize 7}}}
  {
    \pstree{\Tcircle{\mbox{\scriptsize 2}}}
    {
      \Tcircle{\mbox{\scriptsize 1}}
    }
    \pstree{\Tcircle{\mbox{\scriptsize 2}}}
    {
      \Tcircle{\mbox{\scriptsize 1}}
    }
    \pstree{\Tcircle{\mbox{\scriptsize 2}}}
    {
      \Tcircle{\mbox{\scriptsize 1}}
    }
  }
  \pstree{\Tcircle{\mbox{\scriptsize 7}}}
  {
    \pstree{\Tcircle{\mbox{\scriptsize 3}}}
    {
      \pstree{\Tcircle{\mbox{\scriptsize 2}}}
      {
        \Tcircle{\mbox{\scriptsize 1}}
      }
    }
    \pstree{\Tcircle{\mbox{\scriptsize 3}}}
    {
      \pstree{\Tcircle{\mbox{\scriptsize 2}}}
      {
        \Tcircle{\mbox{\scriptsize 1}}
      }
    }
  }
}
\end{array}$$

The number of different trees grows very fast with the number of nodes
$n$. Since Masao has some problems with large numbers, he decides to add
three conditions:

1.  All the subtrees of each node must have the same size.

2.  That size must be prime (unless $n = 2$).

3.  All the (sub)trees must be specular.

These restrictions reduce the number of trees dramatically. For
instance, only the last of the four trees above fulfills all the
restrictions. The first tree does not fulfill (i), the second tree
fulfills (i) but not (ii), and the third tree fulfills (i) and (ii) but
not (iii).

## Input

Input consists of several numbers $n$ between 1 and 500.

## Output

For every given $n$, print the number of general rooted trees with $n$
nodes that fulfill the three conditions above. You, and Masao in
particular, may be happy to know that this number always fits in a C++
`long long`.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T11:59:14.095Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
