# Mate in one

Given several chess positions, tell if white can checkmate in one
movement. The given positions always follow these properties:

- It is white's turn.

- Black has only the king.

- White does not have any pawns.

- White cannot castle.

Please remember these rules:

- A king can never move into an attacked position.

- In particular, both kings cannot be in adjacent cells.

- A king can eat an adjacent enemy piece if it is not defended by any
  other piece.

- A position is checkmate if the king is threatened and it has no valid
  movement.

- A king can checkmate by moving, if by this another piece attacks the
  enemy king.

## Input

Input consists of several cases. Each case begins with the position of
the black king, followed by the number $n$ of white pieces (between 2
and 16), followed by the position of the white pieces. Positions are
codified with the kind of piece ('`K`' for king, '`Q`' for queen, '`B`'
for bishop, '`N`' for knight, '`R`' for rook), followed by the column
(between '`a`' and '`h`'), followed by the row (between 1 and 8). There
are no two pieces on the same cell, and no piece is threatening the
black king.

## Output

For every case, print the only movement that checkmates the black king:
the kind of piece, and the position to move to. If it is impossible to
checkmate in one, print "`NO`". If there is more than one movement that
checkmates in one, print "`>1`".

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T11:53:58.325Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
