# Gramaticando

En este problema usaremos la siguiente terminología. Las letras
mayúsculas son *conjuntos*. Cualquier otro símbolo (letra minúscula,
símbolo de puntuación, etc.) es un *carácter*. Una *regla* es una
expresión que sirve para definir las *palabras* que pertenecen a un
conjunto. Por ejemplo, la regla

$$S \leftarrow aS \ \cup\  bT \ \cup\  .$$

indica que las palabras de $S$ son:

- El carácter punto (`.`).

- Cualquier palabra de $S$, precedida por una letra '`a`', como por
  ejemplo, `a.`, `aa.`, `aaa.`, `aaaa.`, etc.

- Cualquier palabra de $T$, precedida por una letra '`b`'.

Estos tres modos de obtener palabras para el conjunto se denominan
*producciones*. Está claro que, a menos que sepamos cuáles son las
palabras de $T$, no podremos conocer todas las palabras de $S$. Si al
ejemplo anterior le añadiéramos la regla

$$T \leftarrow aS \ \cup\  .$$

podrías comprobar que el conjunto $S$ estaría formado por las palabras

::: center
`.` `a.` `b.` `aa.` `ab.` `ba.` `aaa.` `aab.` `aba.` `baa.` `bab.` ...
:::

Otro ejemplo: si consideras las reglas

$$\begin{align*}
P & \leftarrow ()P\ \cup\ (K)P \ \cup\ . \\
K & \leftarrow ()\ \cup\ (K)\ \cup\ (K)K
\end{align*}$$

descubrirás que $P$ es (exactamente) el conjunto de las expresiones bien
parentizadas, acabadas en punto (`.`).

En este problema te pedimos que, a partir de una descripción de
conjuntos a base de reglas, calcules cuántas palabras de un cierto
tamaño pertenecen a un conjunto. Además, si la misma palabra puede
crearse de varios modos distintos (como en el ejemplo 2), debes contarla
tantas veces como modos distintos haya de crearla.

## Entrada

La entrada empieza con varias reglas (entre $1$ y $10$). Cada regla se
describe en una línea: empieza con una letra mayúscula (el conjunto)
seguido de un espacio, los símbolos `<---`, y otro espacio. A
continuación, y en la misma línea, se da una cantidad *indeterminada*,
posiblemente vacía, de producciones. Las producciones se separan por
espacios, y pueden contener cualquier combinación de conjuntos (letras
mayúsculas) y otros símbolos, exceptuando el símbolo guión (`-`).
Después de la última regla se da una línea formada por cinco guiones.

Se da una única regla para cada conjunto que aparece en una producción.
No aparecerán producciones formadas por una única letra mayúscula, ni
producciones con más de 10 caracteres, ni reglas con más de 10
producciones. Una regla sin producciones indica que el conjunto
correspondiente es el vacío (no tiene ninguna palabra, de ningún
tamaño).

A continuación, se plantea una cantidad indeterminada de preguntas. Cada
pregunta es una línea de la forma "$X$ $n$", donde $X$ es uno de los
conjuntos para los cuales hay regla, y $1\leq n\leq 100$ es el tamaño
por el que se pregunta.

Dispones de un segundo de CPU para resolver cada entrada.

## Salida

Para cada pregunta "`X` $n$", hay que responder en una línea cuántas
palabras de $n$ letras tiene el conjunto $X$. Todas las respuestas serán
menores a $10^9$.

## Puntuación

- **TestA:**

  Resolver 20 entradas, con como mucho 10 preguntas cada una, donde
  todas las producciones serán del tipo `aB` o `c`, como en el ejemplo
  1.

<!-- -->

- **TestB:**

  Resolver 20 entradas, con como mucho 1000 preguntas cada una, donde
  ninguna producción tendrá más de 2 letras de conjunto, como en el
  ejemplo 2.

<!-- -->

- **TestC:**

  Resolver 20 entradas cualesquiera, con 1000 preguntas cada una.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T11:40:26.183Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
