# Old Dalmatian

+:---------------------------------+:----------------------------------+
| Met, the psycho-killer bear, is  | ![image](met.eps){height="4.8cm"} |
| an icon of Slovenia. This is why |                                   |
| Metel, a toy factory in the      |                                   |
| neighbourhood of Metelkova of    |                                   |
| the Slovenian capital Ljubljana, |                                   |
| wants to start the production of |                                   |
| a series of plush bears          |                                   |
| featuring Met and his friends.   |                                   |
| Moreover, the members of the     |                                   |
| executive board of Metel want to |                                   |
| mimic the great success of       |                                   |
| Fur-bees, the speaking hairy     |                                   |
| insects, and have decided that   |                                   |
| Met and his friends must also be |                                   |
| able to speak.                   |                                   |
|                                  |                                   |
| Given their Balkan origins, they |                                   |
| have decided that the bears will |                                   |
| speak in Old Dalmatian, a        |                                   |
| language of the twelfth century, |                                   |
| a time when many brave warriors  |                                   |
| were raised in that noble land.  |                                   |
+----------------------------------+-----------------------------------+

An extract from the *Old Dalmatian Grammar*, written by the Augustine
monk Saint Thelonius of Antioch in the sixteenth century, can give an
impression of the language:

> "As a language of warriors, Old Dalmatian was simple. Sentences
> started with a subject, next came a single verb, and there could be an
> object after the verb. The subject and object consisted in a single
> noun, optionally preceded by a single adjective. Adjectives and nouns
> finished in **-o** if they were singular, and in **-a** if they were
> plural. A noun and its adjective had to agree in grammatical number.
> Verbs had a single form, formed by adding **-ta** to the verb root and
> meaning past tense, as there was no future for Old Dalmatians. (How
> prophetic these words of Saint Thelonius turned out to be!) The word
> order was the same as in English, with words written with no
> separation between them."

Since there has been no speaker of *Modern* Dalmatian (not to mention
*Old* Dalmatian) for more than a century, every toy in the Met series
will come with an electronic translator, made in China and painted with
bright red paint, which will translate the Dalmatian sentences to the
buyer's native language.

As engineer of an enterprise subcontracted by an enterprise
subcontracted by an enterprise subcontracted by Metel, your task is to
design the core of the English version of the electronic translator: the
module which converts the Dalmatian sentence to an English sentence.

## Input

First of all comes a Dalmatian to English dictionary, consisting of a
series of lines containing four fields each: the root of the Dalmatian
word; a single character '`v`', '`n`' or '`a`' to tell if the word is a
verb, noun or adjective; and the word translated to English, in singular
and plural form if it is a noun or adjective, and in infinitive and
simple past form if it is a verb. In some nouns, the value of the last
field is an asterisk, meaning that the word admits no plural. All words
are lowercase. The dictionary ends with a line with four asterisks.

Next comes a sequence of lines, each one containing a sentence in Old
Dalmatian, all in lowercase and ended in a dot. The last sentence
finishes with two consecutive dots, which was an Old Dalmatian form of
invitation to stop speaking and start killing.

## Output

For each sentence in Old Dalmatian, print all the possible translations
of that sentence in English, all in lowercase and finished with a dot,
in alphabetical order. A blank line must separate the set of
translations for different input sentences. If a sentence has no correct
and grammatical translation, print a single line with "`???`".

## Problem information

Author: Edgar Gonzàlez

Generation: 2026-01-25T11:38:47.374Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
