# Become a professional bio-scientist

DNA (deoxyribonucleic acid) is the molecule that encapsulates all the
information of the life species. The encoding is done through four
nucleotides: adenine, thymine, cytosine and guanine that are usually
abbreviated by A, T, C, G. In each position of one DNA strand we can
have just one of these nucleotides and the paired strand codifies the
opposite base (A links with T, C with G) so the molecule encodes two
bits per base pair.

Genes are segments of the DNA that code proteins. Finding genes in a DNA
is a common and important task in bioinformatics. This is a complex task
because there may be skips and mutations in the sequences and DNA
molecules are very long. Human DNA contains, for instance, around 2900
million base pairs (Mbp) and is not the longest one, the one of an ameba
is 200 times longer!

We are going to simplify a little bit this: the problem you need to
solve is to find the first position of a gene coded as nucleotides in a
full DNA coded in the same way. The gene may have a maximum of one
mutation, so you need to find perfect matches or matches for all
nucleotides except one.

## Input

First word is the the full DNA to match against. Then follow each gene
as a word.

## Output

You need to output the first matching position (0 if it matches at first
position) or a dash if there is no match. In case of a match, output the
number of mutations as well (0 or 1).

## Observation

This problem does not have private test cases. It's up to you to prepare
them! In order to be sure you do that, please add one comment at the end
of the program wich includes a valid input whose output is

    -
    0 0
    1 0
    2 0
    3 0
    0 1
    1 1
    2 1
    3 1

## Problem information

Author: CodeWars

Generation: 2026-01-25T11:38:29.484Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
