# Partial sums

Given an array $A[0 ~..~ n-1]$ and an index $i$, the $i$-th partial sum
of $A$ is $\sum_{0\le j\le i} A[j]$. Here, you have to implement a data
structure to efficiently compute partial sums. The operations you must
consider are the creation of an array with all its values initialized to
zero, the modification of a value, and the query of a partial sum.

## Input

Input consists of a non-empty sequence of commands. Every command begins
with a letter to identify it, followed by one or two integer-number
parameters. These are the possible commands:

- "`r `$n$" resets (or creates) an array of $n$ integer numbers to zero.
  Assume $1 \le n \le 10^5$.

- "`s `$i$` `$x$" sets the possition $i$ to $x$. Assume $0\le i< n$ and
  $-100\le x\le 100$.

- "`g `$i$" gets (and prints) the $i$-th partial sum. Assume
  $0\le i< n$.

In general, there are much more set and get commands than reset
commands. The first command is always a reset.

## Output

For each get command, print the corresponding partial sum. Print the
output corresponding to each reset command on a unique line, separated
by spaces.

## Problem information

Author: Jordi Petit

Generation: 2026-01-25T11:35:07.529Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
