# Haskell --- Expressions

Es vol tenir un mòdul per a manipular i avaluar expressions d'enters amb
operacions de suma, resta, multiplicació i divisió. Per això, es
defineix el tipus següent:

        data Expr = Val Int | Add Expr Expr | Sub Expr Expr | Mul Expr Expr | Div Expr Expr

Per exemple, `Add (Val 3) (Div (Val 4) (Val 2))` representa $3 + 4 / 2$,
que s'avalua a 5.

## 1. Avaluació sense errors (20 punts)

Utilitzant el tipus `Expr`, definiu una operació `eval1 :: Expr -> Int`
que, donada una expressió, en retorni la seva avaluació. Podeu suposar
que mai hi haurà divisions per zero.

## 2. Avaluació amb indicació d'error (30 punts)

Utilitzant el tipus `Expr`, definiu una operació
`eval2 :: Expr -> Maybe Int` que, donada una expressió, en retorni la
seva avaluació com un valor `Just`. En el cas que es produeixi una
divisió per zero, el resultat ha de ser `Nothing`. Segurament voleu usar
la notació `do` sobre la mònada `Maybe a`.

## 3. Avaluació amb text d'error (30 punts)

Utilitzant el tipus `Expr`, definiu una operació
`eval3 :: Expr -> Either String Int` que, donada una expressió, en
retorni la seva avaluació com un valor `Right`. En el cas que es
produeixi una divisió per zero, el resultat ha de ser `Left "div0"` per
indicar l'error en qüestió. Segurament voleu usar la notació `do` sobre
la mònada `Either a b`.

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-02-03T17:02:09.695Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
