# Haskell --- Computations (2)

These problems are inspired in some of the problems from Project Euler.
You can find them at [https://projecteuler.net]{.sans-serif}.

1.  The sum of the squares of the first 10 natural numbers is
    $1^2+2^2+\dots+10^2=385$. The square of the sum of the first 10
    natural numbers is $(1+2+\dots+10)^2=55^2=3025$. Therefore, the
    difference between the sum of the squares of the first 10 natural
    numbers and the square of the sum of the first 10 natural numbers is
    $3025 - 385 = 2640$.

    Write a function `diffSqrs :: Integer -> Integer` that, given a
    natural $n$, returns the difference between the sum of the squares
    of the first $n$ natural numbers and the square of the sum of the
    first $n$ natural numbers.

2.  A Pythagorean triplet are three natural numbers $(a,b,c)$ such that
    $a^2+b^2=c^2$. Write a function
    `pythagoreanTriplets :: Int -> [(Int, Int, Int)]` that, given a
    natural $n\ge1$, returns the list of all Pythagorean tripletes that
    add up to $n$. Each triplet must be sorted in such a way that
    $a\le b\le c$ and the list must be sorted according to $a$.

3.  Write a function `tartaglia :: [[Integer]]` that returns an infinite
    list with the rowss of the Tartaglia's triangle (also known as
    Pascal's triangle).

4.  Write a function `sumDigits :: Integer -> Integer` that returns the
    sum of all digits of a natural number. Use high order functions
    rather than recursion.

5.  Write a function `digitalRoot :: Integer -> Integer` that returns
    the digital root of a natural number. Use high order functions
    rather than recursion.

## Scoring

Each function scores 20 points.

## Problem information

Author: Unknown\
Translator: Jordi Petit

Generation: 2026-02-03T17:00:25.914Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
