# Encriptación polialfabética

En una encriptación *monoalfabética* todas las letras de un mensaje se
transforman en otras de distintas, siguiendo siempre la misma regla. El
ejemplo más famoso es la encriptación del César, donde se cambia cada
letra de un mensaje por aquella que está $k$ posiciones adelante en el
orden del alfabeto, dando la vuelta si es necesario. Por ejempo, si
$k=1$, al cifrar un texto tranformaríamos todas las `A` en `B`; todas
las `D` en `E`; y todas las `Z` en `A`.

Las encriptaciones monoalfabéticas son fáciles de descifrar usando,
simplemente, estadísticas y un diccionario, puesto que algunas palabras
pequeñas como 'si', 'no', 'el', 'la', 'que', 'de', 'en', etc. aparecen
con mucha frecuencia.

Para solucionar este problema, encriptaremos el texto usando una
codificación un poco mejor, la encriptación *polialfabética*, que
consiste en usar varias encriptaciones monoalfabéticas distintas y un
patrón que nos indica qué clave hay que usar para cada letra. Por
ejemplo, si usamos dos claves tipo César como las siguientes

    Texto plano -> a b c d e f g h i j k l m n o p q r s t u v w x y z
    C1(k = 5)   -> f g h i j k l m n o p q r s t u v w x y z a b c d e
    C2(k = 19)  -> t u v w x y z a b c d e f g h i j k l m n o p q r s

y un patrón `C1 C2 C2 C1 C2 ` que se va repitiendo a medida que se
encripta, tendríamos que "`bob`" se transformaría en "`ghu`" y
"`que secreto`" se transformaría en "`vnx xxhkxyh`".

## Entrada

La entrada consta de un número indeterminado de casos de prueba. Cada
caso de pruebas empieza con una línea con el número $C$ de claves,
seguido de una línea con $C$ valores $k$ para indicar los
desplazamientos del cifrado del Caesar que se utiliza, seguido de una
tercera línea con un número indeterminado de valores entre $1$ y $C$ que
forman el patrón. A continuación, una línea con la cadena de texto
'CIFRAR' o 'DESCIFRAR', seguido de un número indeterminado de líneas de
texto con el mensaje. Una línea con un carácter punto (`.`) marca el
final del mensaje, y no debe cifrarse o descifrarse. Sólo se debe cifrar
y descifrar aquellos caracteres del mensaje que sean del abecedario,
tanto mayúsculas como minúsculas.

Un caso de pruebas con $C<1$ indica el final de la entrada.

## Salida

Por la salida debes escribir el texto cifrado o descifrado, según se
pida. Escribe un salto de línea entre distintos casos de prueba.

## Puntuación

- **Test1:**

  Resolver varios casos sencillos de cifrados, donde el texto únicamente
  contiene letras mayúsculas y minúsculas.

<!-- -->

- **Test2:**

  Resolver varios casos sencillos de descifrados, donde el texto
  únicamente contiene letras mayúsculas y minúsculas.

<!-- -->

- **Test3:**

  Resolver varios casos sencillos de cifrados y descifrados, donde el
  texto únicamente contiene letras mayúsculas y minúsculas.

<!-- -->

- **Test4:**

  Resolver varios casos con cifrados incluyendo espacios y otros
  caracteres.

<!-- -->

- **Test5:**

  Resolver varios casos con descifrados incluyendo espacios y otros
  caracteres.

<!-- -->

- **Test6:**

  Resolver varios casos con cifrados y descifrados incluyendo espacios y
  otros caracteres.

## Información del problema

Autoría: Javier Segovia

Generación: 2026-01-25T11:35:31.913Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
