# Jaccard index

The *Jaccard index* is a statistic used for comparing the similarity and
diversity of two sets. Namely, the Jaccard index $J(A,B)$ of $A$ and $B$
is $$J(A,B) = \frac{\mid A\cap B\mid }{\mid A\cup B\mid }.$$

For example, the Jaccard index of the sets $\{1,2,3\}$ and $\{3,4\}$ is
$0.25$.

Write a program to compute the Jaccard index of pairs of sets of
integers.

## Input

The input consists of several cases. Each case starts describes two sets
$A$ and $B$. The first set $A$ starts with its cardinality $m \geq 0$
and then follow its $m$ integer elements in strictly increasing order.
The second set $B$ starts with its cardinality $m \geq 0$ and then
follow its $n$ integer elements in strictly increasing order. For each
case, $m+n\ge1$.

## Output

For each case in the input, print the Jaccard index of its two sets in a
different line with 3 digits of precision.

## Hint

- Basic set theory may save you some valuable coding time.

- Use \@cout.setf(ios::fixed); cout.precision(3);@ at the beginning of
  your program to print real numbers with 3 digits of precision.

## Problem information

Author: Guillem Godoy, Jordi Petit

Generation: 2026-01-25T11:33:28.054Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
