# Fractals

Consider an $n \times m$ matrix of chars $M$, which may include '`.`',
'`X`', '`p`' and '`n`'. Define the "negative" of $M$ as the matrix
result of replacing each '`.`' by '`X`', each '`X`' by '`.`', each '`p`'
by '`n`', and each '`n`' by '`p`'. For instance, the negative of

    XpX     .n.
    .n.     XpX

is

We can use $M$ to create some kind of fractals, by repeatedly replacing
each character $c$ of the current matrix by an $n \times m$ matrix, with
these rules:

- If $c =$ '`.`', replace $c$ by an $n \times m$ matrix with all '`.`'.

- If $c =$ '`X`', replace $c$ by an $n \times m$ matrix with all '`X`'.

- If $c =$ '`p`', replace $c$ by $M$.

- If $c =$ '`n`', replace $c$ by the negative of $M$.

With the example above, after one step we get

    XXXXpXXXX
    XXX.n.XXX
    ....n....
    ...XpX...

and after two steps we get

    XXXXXXXXXXXXXpXXXXXXXXXXXXX
    XXXXXXXXXXXX.n.XXXXXXXXXXXX
    XXXXXXXXX....n....XXXXXXXXX
    XXXXXXXXX...XpX...XXXXXXXXX
    .............n.............
    ............XpX............
    .........XXXXpXXXX.........
    .........XXX.n.XXX.........

Can you simulate this process $k$ times?

## Input

Input consists of several cases. Every case begins with $n$, $m$ and
$k$, followed by an $n \times m$ matrix $M$ as explained above. Assume
that $n$ and $m$ are between 1 and 100, and $k \ge 1$.

## Output

Print $k$ matrices for each case: the result after one step, two steps,
etc. Separate these matrices by blank lines. End each case with 10
asteriscs. When printing the results, replace each '`p`' by '`X`', and
each '`n`' by '`.`'. With the given cases, no result will have more than
$10^6$ chars.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T11:32:33.461Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
