# Bolsa

Te pedimos que hagas un programa que muestre la cotización de una o
varias acciones de bolsa a lo largo de un día, sabiendo que en cada
instante el valor de cada acción solo puede subir o bajar una unidad.

## Entrada

La entrada contiene como mucho 10 acciones. Cada acción se da en una
línea con el nombre de la acción (de 3 a 5 letras mayúsculas), seguido
de su valor inicial (entre 1 y 100) seguido por $1\le k\le 100$
caracteres de tipo '`U`' (la acción sube una unidad) o '`D`' (la acción
baja una unidad).

Se te garantiza que todas las acciones tienen el mismo número $k$ de
cambios a lo largo del día; no hay dos acciones que empiecen valiendo lo
mismo; y que en todo momento el precio de todas las acciones estará
entre 1 y 100, ambos inclusive.

## Salida

Escribe la cotización de las acciones como se muestra en los ejemplos,
usando caracteres '`/`', '`\`' y '`X`' para la gráfica, y los caracteres
'$\vert$' y '`-`' para los ejes. Fíjate, en particular, que la última
línea contiene todo de caracteres '`-`' (es el eje $y=0$ de la gráfica);
que hay que escribir el nombre de la acción a la izquierda de la
gráfica; que hay que dejar más o menos espacio a la izquierda en función
de la longitud de los nombres de las acciones; y que no hay que escribir
líneas innecesarias en la gráfica.

## Observación

Recuerda que en la mayoría de los lenguajes de programación, para
escribir la contrabarra ('`\`') es necesario escribir 2 contrabarras
seguidas (`’\\’`).

## Puntuación

- **TestA:**

  Entradas con una única acción que siempre empieza con valor 1.

<!-- -->

- **TestB:**

  Entradas con hasta 10 acciones.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T11:29:03.049Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
