# Bag of peanuts

You have several peanuts inside a bag. Before you start eating some of
them, you decide that you will eat exactly $t$ peanuts in total.
Repeatedly, you will take a peanut at random from the bag, and eat it.
However, it happens that some of the peanuts are not complete, but just
a half-peanut. Therefore, it is possible that you will not eat exactly
$t$ peanuts.

For instance, suppose that the bag has $c = 1$ complete peanuts, $h = 2$
half-peanuts, and that you want to eat exactly one peanut (that is,
$t = 1$). In this case, with probability $1/3$ you will eat the complete
peanut, and stop. Otherwise, after eating a half-peanut, you will eat
another peanut, which can be the remaining half-peanut (this would be a
success, since you would have eaten $1/2 + 1/2 = t$ peanuts) or the
complete peanut (this would be a failure, bacause you would have eaten
$1/2 + 1 > t$ peanuts). Altogether, the probability of success is
$1/3 + (2/3) \cdot (1/2) = 2/3$.

Given $c$, $h$ and $t$, can you compute the probability of success?

## Input

Input consists of several cases, with only integer numbers, each one
with $c$, $h$ and $t$. Assume $0 \le c \le 1000$, $0 \le h \le 2000$,
and $0 \le t \le c + \lfloor h/2 \rfloor$.

## Output

For every case, print with four digits after the decimal point the
probability of eating exactly $t$ peanuts when you are given a bag with
$c$ complete peanuts and $h$ half-peanuts.

## Hint

The expected solution has cost $O(t)$. The given bounds for $c$, $h$ and
$t$ are rather small, in order to reduce the magnitude of numerical
errors. Even so, use the type `long double` and try hard to avoid
underflows and overflows. Good luck!

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T11:25:45.649Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
