# Pattern in a matrix

Using the definitions

        typedef vector<char> Row;
        typedef vector<Row> Matrix;

implement a function

        int pattern(const Matrix& P, const Matrix& M);

to compute how many times the pattern \@P@ appears inside the matrix
\@M@. It is guaranteed that both matrices are rectangular. Furthermore,
if \@P@ has dimensions $r_1 \times c_1$ and \@M@ has dimensions
$r_2 \times c_2$, then it holds $1 \le r_1 \le r_2 \le 50$ and
$1 \le c_1 \le c_2 \le 50$.

For instance, the pattern $2 \times 3$ to the left appears twice in the
matrix $3 \times 4$ to the right. $$\left(
\begin{array}{ccc}
\mbox{a} & \mbox{b} & \mbox{b} \\
\mbox{b} & \mbox{b} & \mbox{c}
\end{array}
\right)
\hspace*{4cm}
\left(
\begin{array}{cccc}
\mbox{a} & \mbox{a} & \mbox{b} & \mbox{b} \\
\mbox{a} & \mbox{b} & \mbox{b} & \mbox{c} \\
\mbox{b} & \mbox{b} & \mbox{c} & \mbox{a}
\end{array}
\right)$$

You may implement auxiliar procedures if needed.

## Hint

The expected solution simply checks the pattern on every possible
position of the matrix.

## Observation

You only need to submit the required procedure; your main program will
be ignored.

## Problem information

Author: Unknown\
Translator: Salvador Roura

Generation: 2026-01-25T11:22:08.936Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
