# Árbol de rocas (2)

Los habitantes de cierto remoto, desarbolado lugar tienen la tradición
de construir esculturas en forma de árbol sobre un río cercano. Cuenta
la leyenda que un artista observó que en una zona del río había hileras
de rocas paralelas a la orilla, y decidió usarlas para hacer una gran
figura en forma de árbol.

El mismo proceso es todavía usado por los actuales pobladores. Los
ayudantes del artista se sitúan cada uno en una roca, excepto en
aquellas de la última hilera, la más alejada de la orilla. El artista se
coloca en la orilla. Todo el mundo (incluyendo el artista) lleva una
bolsa con cuerdas acabadas en ganchos. Cada persona elige un número
cualquiera de cuerdas (o ninguna) y las lanza sobre las rocas de la
hilera siguiente. El genio de la idea, el único que permanece en tierra,
lanza sus cuerdas desde tierra hacia las rocas de la primera hilera.

Para que el diseño resultante sea considerado válido, es necesario que
se cumpla lo siguiente:

- Cada roca solo puede recibir un gancho (de la hilera inmediatamente
  inferior).

- Dos cuerdas no pueden cruzarse, aunque vayan a rocas distintas.

- El resultado final es un árbol (grafo conexo y sin ciclos), del que
  todas las rocas forman parte.

Estos son los dos únicos diseños que pueden formarse con 2 piedras en la
primera hilera, 1 piedra en la segunda, y 3 en la tercera:

::::: center
::: pspicture
(9,5) (0,0)(0,1)(9,1)(9,0) (0,2)(9,2) (0,3)(9,3) (0,4)(9,4)
(4,1)0.21a(4,1) (3,2)0.22a(3,2) (6,2)0.22b(6,2) (5,3)0.23a(5,3)
(2,4)0.24a(2,4) (3,4)0.24b(3,4) (6,4)0.24c(6,4)
:::

::: pspicture
(9,5) (0,0)(0,1)(9,1)(9,0) (0,2)(9,2) (0,3)(9,3) (0,4)(9,4)
(4,1)0.21a(4,1) (3,2)0.22a(3,2) (6,2)0.22b(6,2) (5,3)0.23a(5,3)
(2,4)0.24a(2,4) (3,4)0.24b(3,4) (6,4)0.24c(6,4)
:::
:::::

El punto 3 es especialmente importante: un primo lejano del artista
perdió la licencia porque sus dibujos consistían en varios árboles (un
"bosque"), y no en un único árbol, tal y como mandan los cánones.

Ayuda al artista calculando de cuántas formas diferentes puede quedar su
obra según dichas restricciones.

## Entrada

La entrada contiene un número indeterminado de casos. Cada caso se da en
dos líneas. La primera línea contiene el número $k$ de hileras de
piedras del río, mientras que la segunda línea contiene los $k$ números
de rocas de cada hilera, empezando por la más cercana a tierra, siempre
mayores que cero.

## Salida

Para cada caso, se debe imprimir en una línea el número de formas
diferentes. Como este número puede ser muy grande, imprímelo módulo
$10007$.

## Puntuación

- **Test1:**

  Resolver entradas con no más de 50 casos, cada uno de los cuales tiene
  una sola hilera ($k=1$) y no hay más de 50 rocas por hilera.

<!-- -->

- **Test2:**

  Resolver entradas con no más de 50 casos, cada uno de los cuales tiene
  una o dos hileras ($k\le 2$) y no hay más de 50 rocas por hilera.

<!-- -->

- **Test3:**

  Resolver entradas con no más de 50 casos, cada uno de los cuales tiene
  menos de 20 hileras ($k < 20$) y no hay más de 50 rocas por hilera.

<!-- -->

- **Test4:**

  Resolver entradas con no más de 50 casos, cada uno de los cuales tiene
  menos de 200 hileras ($k < 200$) y no hay más de 200 rocas por hilera.

<!-- -->

- **Test5:**

  Resolver entradas con no más de 1000 casos, cada uno de los cuales
  tiene menos de 2000 hileras ($k < 2000$) y no hay más de 2000 rocas
  por hilera.

## Información del problema

Autoría: Álex Álvarez

Generación: 2026-01-25T11:21:20.133Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
