# Triple Dobles

A cada partit de bàsquet es publiquen les estadístiques de cada jugador.
Aquestes estadístiques recullen 5 categories: punts, rebots,
assistències, taps i recuperacions. Es diu que un jugador ha fet un
*triple-doble* quan té un valor mínim de 10 a almenys 3 de les 5
categories anteriors. Un tipus especial de triple-doble és el *doble
triple-doble*. Això es produeix quan té un valor mínim de 20 a almenys 3
de les 5 categories. Per exemple:

- 20 10 5 15 30 i 13 10 5 15 30 : són triple-dobles

- 5 20 10 20 25 i 15 20 10 20 25: són doble triple-dobles

Donades les estadístiques de les jugadores de la LFB en els partits ja
disputats, les volem llistar ordenades segons el número de doble
triple-dobles i triple-dobles que han fet.

És obligatori implementar i utilitzar el següent:

    @dataclass
    class Player:
        name: str
        dtd: int      # número de doble triple-dobles
        td: int       # número de triple-dobles (que no són doble triple-doble)

    def read_player(p: int) -> Player:
        '''
        Pre: p >= 0; a l'entrada hi ha un nom seguit de les seves estadístiques a p partits
        Post: retorna la informació d'una jugadora segons les dades que hi havia a l'entrada
        '''
        ...

## Entrada

L'entrada comença amb un enter $p \ge 0$ que representa el número de
partits jugats. A continuació, segueix un enter $n >= 0$ i una seqüència
amb la informació de $n$ jugadores. Per cada jugadora, ens donen el seu
nom i les seves estadístiques al llarg dels $p$ partits jugats. Per cada
partit, apareixen els punts, rebots, assistències, taps i recuperacions.

## Sortida

Volem veure la informació de les jugadores (nom, número de dobes
triples-dobles i número de triples-dobles) ordenats segons els següents
criteris: primer les que tinguin més dobles triple-dobles, en cas
d'empat, les que tinguin més triples-dobles (que no siguin dobles
triple-dobles) i, si persisteix l'empat, per ordre lexicogràfic del seu
nom.

## Informació del problema

Autoria: Emma Rollón

Generació: 2026-01-25T11:18:12.147Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
